<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountCustomerDetail StructType
 * @subpackage Structs
 */
class DiscountCustomerDetail extends Entity
{
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerName;
    /**
     * Constructor method for DiscountCustomerDetail
     * @uses DiscountCustomerDetail::setCustomerID()
     * @uses DiscountCustomerDetail::setCustomerName()
     * @param \AcumaticaConfig\StructType\StringValue $customerID
     * @param \AcumaticaConfig\StructType\StringValue $customerName
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $customerID = null, \AcumaticaConfig\StructType\StringValue $customerName = null)
    {
        $this
            ->setCustomerID($customerID)
            ->setCustomerName($customerName);
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerID
     * @return \AcumaticaConfig\StructType\DiscountCustomerDetail
     */
    public function setCustomerID(\AcumaticaConfig\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerName
     * @return \AcumaticaConfig\StructType\DiscountCustomerDetail
     */
    public function setCustomerName(\AcumaticaConfig\StructType\StringValue $customerName = null)
    {
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\DiscountCustomerDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
