<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateTimeSearch StructType
 * @subpackage Structs
 */
class DateTimeSearch extends DateTimeValue
{
    /**
     * The Condition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Condition;
    /**
     * The Value2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Value2;
    /**
     * Constructor method for DateTimeSearch
     * @uses DateTimeSearch::setCondition()
     * @uses DateTimeSearch::setValue2()
     * @param string $condition
     * @param string $value2
     */
    public function __construct($condition = null, $value2 = null)
    {
        $this
            ->setCondition($condition)
            ->setValue2($value2);
    }
    /**
     * Get Condition value
     * @return string
     */
    public function getCondition()
    {
        return $this->Condition;
    }
    /**
     * Set Condition value
     * @uses \AcumaticaConfig\EnumType\DateTimeCondition::valueIsValid()
     * @uses \AcumaticaConfig\EnumType\DateTimeCondition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $condition
     * @return \AcumaticaConfig\StructType\DateTimeSearch
     */
    public function setCondition($condition = null)
    {
        // validation for constraint: enumeration
        if (!\AcumaticaConfig\EnumType\DateTimeCondition::valueIsValid($condition)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $condition, implode(', ', \AcumaticaConfig\EnumType\DateTimeCondition::getValidValues())), __LINE__);
        }
        $this->Condition = $condition;
        return $this;
    }
    /**
     * Get Value2 value
     * @return string
     */
    public function getValue2()
    {
        return $this->Value2;
    }
    /**
     * Set Value2 value
     * @param string $value2
     * @return \AcumaticaConfig\StructType\DateTimeSearch
     */
    public function setValue2($value2 = null)
    {
        // validation for constraint: string
        if (!is_null($value2) && !is_string($value2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value2)), __LINE__);
        }
        $this->Value2 = $value2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\DateTimeSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
