<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerResult StructType
 * @subpackage Structs
 */
class CustomerResult extends Entity
{
    /**
     * The CustomerResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CustomerResult[]
     */
    public $CustomerResult;
    /**
     * The Count
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $Count;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for CustomerResult
     * @uses CustomerResult::setCustomerResult()
     * @uses CustomerResult::setCount()
     * @uses CustomerResult::setStatus()
     * @param \AcumaticaConfig\StructType\CustomerResult[] $customerResult
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @param \AcumaticaConfig\StructType\StringValue $status
     */
    public function __construct(array $customerResult = array(), \AcumaticaConfig\StructType\IntValue $count = null, \AcumaticaConfig\StructType\StringValue $status = null)
    {
        $this
            ->setCustomerResult($customerResult)
            ->setCount($count)
            ->setStatus($status);
    }
    /**
     * Get CustomerResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CustomerResult[]|null
     */
    public function getCustomerResult()
    {
        return isset($this->CustomerResult) ? $this->CustomerResult : null;
    }
    /**
     * Set CustomerResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerResult[] $customerResult
     * @return \AcumaticaConfig\StructType\CustomerResult
     */
    public function setCustomerResult(array $customerResult = array())
    {
        foreach ($customerResult as $customerResultCustomerResultItem) {
            // validation for constraint: itemType
            if (!$customerResultCustomerResultItem instanceof \AcumaticaConfig\StructType\CustomerResult) {
                throw new \InvalidArgumentException(sprintf('The CustomerResult property can only contain items of \AcumaticaConfig\StructType\CustomerResult, "%s" given', is_object($customerResultCustomerResultItem) ? get_class($customerResultCustomerResultItem) : gettype($customerResultCustomerResultItem)), __LINE__);
            }
        }
        if (is_null($customerResult) || (is_array($customerResult) && empty($customerResult))) {
            unset($this->CustomerResult);
        } else {
            $this->CustomerResult = $customerResult;
        }
        return $this;
    }
    /**
     * Add item to CustomerResult value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerResult $item
     * @return \AcumaticaConfig\StructType\CustomerResult
     */
    public function addToCustomerResult(\AcumaticaConfig\StructType\CustomerResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CustomerResult) {
            throw new \InvalidArgumentException(sprintf('The CustomerResult property can only contain items of \AcumaticaConfig\StructType\CustomerResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerResult[] = $item;
        return $this;
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $count
     * @return \AcumaticaConfig\StructType\CustomerResult
     */
    public function setCount(\AcumaticaConfig\StructType\IntValue $count = null)
    {
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\CustomerResult
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CustomerResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
