<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerCount StructType
 * @subpackage Structs
 */
class CustomerCount extends Entity
{
    /**
     * The CustomerResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CustomerResult
     */
    public $CustomerResult;
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ToDate;
    /**
     * Constructor method for CustomerCount
     * @uses CustomerCount::setCustomerResult()
     * @uses CustomerCount::setFromDate()
     * @uses CustomerCount::setToDate()
     * @param \AcumaticaConfig\StructType\CustomerResult $customerResult
     * @param \AcumaticaConfig\StructType\DateTimeValue $fromDate
     * @param \AcumaticaConfig\StructType\DateTimeValue $toDate
     */
    public function __construct(\AcumaticaConfig\StructType\CustomerResult $customerResult = null, \AcumaticaConfig\StructType\DateTimeValue $fromDate = null, \AcumaticaConfig\StructType\DateTimeValue $toDate = null)
    {
        $this
            ->setCustomerResult($customerResult)
            ->setFromDate($fromDate)
            ->setToDate($toDate);
    }
    /**
     * Get CustomerResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CustomerResult|null
     */
    public function getCustomerResult()
    {
        return isset($this->CustomerResult) ? $this->CustomerResult : null;
    }
    /**
     * Set CustomerResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\CustomerResult $customerResult
     * @return \AcumaticaConfig\StructType\CustomerCount
     */
    public function setCustomerResult(\AcumaticaConfig\StructType\CustomerResult $customerResult = null)
    {
        if (is_null($customerResult) || (is_array($customerResult) && empty($customerResult))) {
            unset($this->CustomerResult);
        } else {
            $this->CustomerResult = $customerResult;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $fromDate
     * @return \AcumaticaConfig\StructType\CustomerCount
     */
    public function setFromDate(\AcumaticaConfig\StructType\DateTimeValue $fromDate = null)
    {
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $toDate
     * @return \AcumaticaConfig\StructType\CustomerCount
     */
    public function setToDate(\AcumaticaConfig\StructType\DateTimeValue $toDate = null)
    {
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CustomerCount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
