<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends Entity
{
    /**
     * The AccountRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AccountRef;
    /**
     * The ApplyOverdueCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ApplyOverdueCharges;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Attributes
     */
    public $Attributes;
    /**
     * The AutoApplyPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $AutoApplyPayments;
    /**
     * The BillingAddressSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BillingAddressSameAsMain;
    /**
     * The BillingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contact
     */
    public $BillingContact;
    /**
     * The BillingContactSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BillingContactSameAsMain;
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contacts
     */
    public $Contacts;
    /**
     * The CreatedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CreditDaysPastDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $CreditDaysPastDue;
    /**
     * The CreditLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CreditLimit;
    /**
     * The CreditVerification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CreditVerification;
    /**
     * The CreditVerificationRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CreditVerificationRules
     */
    public $CreditVerificationRules;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyRateType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyRateType;
    /**
     * The CustomerClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerClass;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerID;
    /**
     * The CustomerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CustomerName;
    /**
     * The EnableCurrencyOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $EnableCurrencyOverride;
    /**
     * The EnableRateOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $EnableRateOverride;
    /**
     * The EnableWriteOffs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $EnableWriteOffs;
    /**
     * The FirstDueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $FirstDueDate;
    /**
     * The FOBPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FOBPoint;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The LeadTimedays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $LeadTimedays;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LocationName;
    /**
     * The MainContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contact
     */
    public $MainContact;
    /**
     * The MultiCurrencyStatements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $MultiCurrencyStatements;
    /**
     * The OpenOrdersBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $OpenOrdersBalance;
    /**
     * The OrderPriority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShortValue
     */
    public $OrderPriority;
    /**
     * The ParentRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ParentRecord;
    /**
     * The PaymentInstructions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PaymentInstructions
     */
    public $PaymentInstructions;
    /**
     * The PriceClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PriceClassID;
    /**
     * The PrintDunningLetters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $PrintDunningLetters;
    /**
     * The PrintInvoices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $PrintInvoices;
    /**
     * The PrintStatements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $PrintStatements;
    /**
     * The RemainingCreditLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $RemainingCreditLimit;
    /**
     * The ResidentialDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ResidentialDelivery;
    /**
     * The Salespersons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Salespersons
     */
    public $Salespersons;
    /**
     * The SaturdayDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SaturdayDelivery;
    /**
     * The SendDunningLettersbyEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SendDunningLettersbyEmail;
    /**
     * The SendInvoicesbyEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SendInvoicesbyEmail;
    /**
     * The SendStatementsbyEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $SendStatementsbyEmail;
    /**
     * The ShippingAddressSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShippingAddressSameAsMain;
    /**
     * The ShippingBranch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingBranch;
    /**
     * The ShippingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contact
     */
    public $ShippingContact;
    /**
     * The ShippingContactSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShippingContactSameAsMain;
    /**
     * The ShippingRule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingRule;
    /**
     * The ShippingTerms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingTerms;
    /**
     * The ShippingZoneID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShippingZoneID;
    /**
     * The ShipVia
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ShipVia;
    /**
     * The StatementCycleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StatementCycleID;
    /**
     * The StatementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $StatementType;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The TaxRegistrationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxRegistrationID;
    /**
     * The TaxZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxZone;
    /**
     * The Terms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Terms;
    /**
     * The UnreleasedBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $UnreleasedBalance;
    /**
     * The WarehouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WarehouseID;
    /**
     * The WriteOffLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $WriteOffLimit;
    /**
     * Constructor method for Customer
     * @uses Customer::setAccountRef()
     * @uses Customer::setApplyOverdueCharges()
     * @uses Customer::setAttributes()
     * @uses Customer::setAutoApplyPayments()
     * @uses Customer::setBillingAddressSameAsMain()
     * @uses Customer::setBillingContact()
     * @uses Customer::setBillingContactSameAsMain()
     * @uses Customer::setContacts()
     * @uses Customer::setCreatedDateTime()
     * @uses Customer::setCreditDaysPastDue()
     * @uses Customer::setCreditLimit()
     * @uses Customer::setCreditVerification()
     * @uses Customer::setCreditVerificationRules()
     * @uses Customer::setCurrencyID()
     * @uses Customer::setCurrencyRateType()
     * @uses Customer::setCustomerClass()
     * @uses Customer::setCustomerID()
     * @uses Customer::setCustomerName()
     * @uses Customer::setEnableCurrencyOverride()
     * @uses Customer::setEnableRateOverride()
     * @uses Customer::setEnableWriteOffs()
     * @uses Customer::setFirstDueDate()
     * @uses Customer::setFOBPoint()
     * @uses Customer::setLastModifiedDateTime()
     * @uses Customer::setLeadTimedays()
     * @uses Customer::setLocationName()
     * @uses Customer::setMainContact()
     * @uses Customer::setMultiCurrencyStatements()
     * @uses Customer::setOpenOrdersBalance()
     * @uses Customer::setOrderPriority()
     * @uses Customer::setParentRecord()
     * @uses Customer::setPaymentInstructions()
     * @uses Customer::setPriceClassID()
     * @uses Customer::setPrintDunningLetters()
     * @uses Customer::setPrintInvoices()
     * @uses Customer::setPrintStatements()
     * @uses Customer::setRemainingCreditLimit()
     * @uses Customer::setResidentialDelivery()
     * @uses Customer::setSalespersons()
     * @uses Customer::setSaturdayDelivery()
     * @uses Customer::setSendDunningLettersbyEmail()
     * @uses Customer::setSendInvoicesbyEmail()
     * @uses Customer::setSendStatementsbyEmail()
     * @uses Customer::setShippingAddressSameAsMain()
     * @uses Customer::setShippingBranch()
     * @uses Customer::setShippingContact()
     * @uses Customer::setShippingContactSameAsMain()
     * @uses Customer::setShippingRule()
     * @uses Customer::setShippingTerms()
     * @uses Customer::setShippingZoneID()
     * @uses Customer::setShipVia()
     * @uses Customer::setStatementCycleID()
     * @uses Customer::setStatementType()
     * @uses Customer::setStatus()
     * @uses Customer::setTaxRegistrationID()
     * @uses Customer::setTaxZone()
     * @uses Customer::setTerms()
     * @uses Customer::setUnreleasedBalance()
     * @uses Customer::setWarehouseID()
     * @uses Customer::setWriteOffLimit()
     * @param \AcumaticaConfig\StructType\StringValue $accountRef
     * @param \AcumaticaConfig\StructType\BooleanValue $applyOverdueCharges
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @param \AcumaticaConfig\StructType\BooleanValue $autoApplyPayments
     * @param \AcumaticaConfig\StructType\BooleanValue $billingAddressSameAsMain
     * @param \AcumaticaConfig\StructType\Contact $billingContact
     * @param \AcumaticaConfig\StructType\BooleanValue $billingContactSameAsMain
     * @param \AcumaticaConfig\StructType\Contacts $contacts
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @param \AcumaticaConfig\StructType\ShortValue $creditDaysPastDue
     * @param \AcumaticaConfig\StructType\DecimalValue $creditLimit
     * @param \AcumaticaConfig\StructType\StringValue $creditVerification
     * @param \AcumaticaConfig\StructType\CreditVerificationRules $creditVerificationRules
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @param \AcumaticaConfig\StructType\StringValue $currencyRateType
     * @param \AcumaticaConfig\StructType\StringValue $customerClass
     * @param \AcumaticaConfig\StructType\StringValue $customerID
     * @param \AcumaticaConfig\StructType\StringValue $customerName
     * @param \AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $enableRateOverride
     * @param \AcumaticaConfig\StructType\BooleanValue $enableWriteOffs
     * @param \AcumaticaConfig\StructType\DateTimeValue $firstDueDate
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\ShortValue $leadTimedays
     * @param \AcumaticaConfig\StructType\StringValue $locationName
     * @param \AcumaticaConfig\StructType\Contact $mainContact
     * @param \AcumaticaConfig\StructType\BooleanValue $multiCurrencyStatements
     * @param \AcumaticaConfig\StructType\DecimalValue $openOrdersBalance
     * @param \AcumaticaConfig\StructType\ShortValue $orderPriority
     * @param \AcumaticaConfig\StructType\StringValue $parentRecord
     * @param \AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions
     * @param \AcumaticaConfig\StructType\StringValue $priceClassID
     * @param \AcumaticaConfig\StructType\BooleanValue $printDunningLetters
     * @param \AcumaticaConfig\StructType\BooleanValue $printInvoices
     * @param \AcumaticaConfig\StructType\BooleanValue $printStatements
     * @param \AcumaticaConfig\StructType\DecimalValue $remainingCreditLimit
     * @param \AcumaticaConfig\StructType\BooleanValue $residentialDelivery
     * @param \AcumaticaConfig\StructType\Salespersons $salespersons
     * @param \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery
     * @param \AcumaticaConfig\StructType\BooleanValue $sendDunningLettersbyEmail
     * @param \AcumaticaConfig\StructType\BooleanValue $sendInvoicesbyEmail
     * @param \AcumaticaConfig\StructType\BooleanValue $sendStatementsbyEmail
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain
     * @param \AcumaticaConfig\StructType\StringValue $shippingBranch
     * @param \AcumaticaConfig\StructType\Contact $shippingContact
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingContactSameAsMain
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @param \AcumaticaConfig\StructType\StringValue $shippingZoneID
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @param \AcumaticaConfig\StructType\StringValue $statementCycleID
     * @param \AcumaticaConfig\StructType\StringValue $statementType
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\StringValue $taxRegistrationID
     * @param \AcumaticaConfig\StructType\StringValue $taxZone
     * @param \AcumaticaConfig\StructType\StringValue $terms
     * @param \AcumaticaConfig\StructType\DecimalValue $unreleasedBalance
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     * @param \AcumaticaConfig\StructType\DecimalValue $writeOffLimit
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $accountRef = null, \AcumaticaConfig\StructType\BooleanValue $applyOverdueCharges = null, \AcumaticaConfig\StructType\Attributes $attributes = null, \AcumaticaConfig\StructType\BooleanValue $autoApplyPayments = null, \AcumaticaConfig\StructType\BooleanValue $billingAddressSameAsMain = null, \AcumaticaConfig\StructType\Contact $billingContact = null, \AcumaticaConfig\StructType\BooleanValue $billingContactSameAsMain = null, \AcumaticaConfig\StructType\Contacts $contacts = null, \AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null, \AcumaticaConfig\StructType\ShortValue $creditDaysPastDue = null, \AcumaticaConfig\StructType\DecimalValue $creditLimit = null, \AcumaticaConfig\StructType\StringValue $creditVerification = null, \AcumaticaConfig\StructType\CreditVerificationRules $creditVerificationRules = null, \AcumaticaConfig\StructType\StringValue $currencyID = null, \AcumaticaConfig\StructType\StringValue $currencyRateType = null, \AcumaticaConfig\StructType\StringValue $customerClass = null, \AcumaticaConfig\StructType\StringValue $customerID = null, \AcumaticaConfig\StructType\StringValue $customerName = null, \AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride = null, \AcumaticaConfig\StructType\BooleanValue $enableRateOverride = null, \AcumaticaConfig\StructType\BooleanValue $enableWriteOffs = null, \AcumaticaConfig\StructType\DateTimeValue $firstDueDate = null, \AcumaticaConfig\StructType\StringValue $fOBPoint = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\ShortValue $leadTimedays = null, \AcumaticaConfig\StructType\StringValue $locationName = null, \AcumaticaConfig\StructType\Contact $mainContact = null, \AcumaticaConfig\StructType\BooleanValue $multiCurrencyStatements = null, \AcumaticaConfig\StructType\DecimalValue $openOrdersBalance = null, \AcumaticaConfig\StructType\ShortValue $orderPriority = null, \AcumaticaConfig\StructType\StringValue $parentRecord = null, \AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions = null, \AcumaticaConfig\StructType\StringValue $priceClassID = null, \AcumaticaConfig\StructType\BooleanValue $printDunningLetters = null, \AcumaticaConfig\StructType\BooleanValue $printInvoices = null, \AcumaticaConfig\StructType\BooleanValue $printStatements = null, \AcumaticaConfig\StructType\DecimalValue $remainingCreditLimit = null, \AcumaticaConfig\StructType\BooleanValue $residentialDelivery = null, \AcumaticaConfig\StructType\Salespersons $salespersons = null, \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery = null, \AcumaticaConfig\StructType\BooleanValue $sendDunningLettersbyEmail = null, \AcumaticaConfig\StructType\BooleanValue $sendInvoicesbyEmail = null, \AcumaticaConfig\StructType\BooleanValue $sendStatementsbyEmail = null, \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain = null, \AcumaticaConfig\StructType\StringValue $shippingBranch = null, \AcumaticaConfig\StructType\Contact $shippingContact = null, \AcumaticaConfig\StructType\BooleanValue $shippingContactSameAsMain = null, \AcumaticaConfig\StructType\StringValue $shippingRule = null, \AcumaticaConfig\StructType\StringValue $shippingTerms = null, \AcumaticaConfig\StructType\StringValue $shippingZoneID = null, \AcumaticaConfig\StructType\StringValue $shipVia = null, \AcumaticaConfig\StructType\StringValue $statementCycleID = null, \AcumaticaConfig\StructType\StringValue $statementType = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\StringValue $taxRegistrationID = null, \AcumaticaConfig\StructType\StringValue $taxZone = null, \AcumaticaConfig\StructType\StringValue $terms = null, \AcumaticaConfig\StructType\DecimalValue $unreleasedBalance = null, \AcumaticaConfig\StructType\StringValue $warehouseID = null, \AcumaticaConfig\StructType\DecimalValue $writeOffLimit = null)
    {
        $this
            ->setAccountRef($accountRef)
            ->setApplyOverdueCharges($applyOverdueCharges)
            ->setAttributes($attributes)
            ->setAutoApplyPayments($autoApplyPayments)
            ->setBillingAddressSameAsMain($billingAddressSameAsMain)
            ->setBillingContact($billingContact)
            ->setBillingContactSameAsMain($billingContactSameAsMain)
            ->setContacts($contacts)
            ->setCreatedDateTime($createdDateTime)
            ->setCreditDaysPastDue($creditDaysPastDue)
            ->setCreditLimit($creditLimit)
            ->setCreditVerification($creditVerification)
            ->setCreditVerificationRules($creditVerificationRules)
            ->setCurrencyID($currencyID)
            ->setCurrencyRateType($currencyRateType)
            ->setCustomerClass($customerClass)
            ->setCustomerID($customerID)
            ->setCustomerName($customerName)
            ->setEnableCurrencyOverride($enableCurrencyOverride)
            ->setEnableRateOverride($enableRateOverride)
            ->setEnableWriteOffs($enableWriteOffs)
            ->setFirstDueDate($firstDueDate)
            ->setFOBPoint($fOBPoint)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setLeadTimedays($leadTimedays)
            ->setLocationName($locationName)
            ->setMainContact($mainContact)
            ->setMultiCurrencyStatements($multiCurrencyStatements)
            ->setOpenOrdersBalance($openOrdersBalance)
            ->setOrderPriority($orderPriority)
            ->setParentRecord($parentRecord)
            ->setPaymentInstructions($paymentInstructions)
            ->setPriceClassID($priceClassID)
            ->setPrintDunningLetters($printDunningLetters)
            ->setPrintInvoices($printInvoices)
            ->setPrintStatements($printStatements)
            ->setRemainingCreditLimit($remainingCreditLimit)
            ->setResidentialDelivery($residentialDelivery)
            ->setSalespersons($salespersons)
            ->setSaturdayDelivery($saturdayDelivery)
            ->setSendDunningLettersbyEmail($sendDunningLettersbyEmail)
            ->setSendInvoicesbyEmail($sendInvoicesbyEmail)
            ->setSendStatementsbyEmail($sendStatementsbyEmail)
            ->setShippingAddressSameAsMain($shippingAddressSameAsMain)
            ->setShippingBranch($shippingBranch)
            ->setShippingContact($shippingContact)
            ->setShippingContactSameAsMain($shippingContactSameAsMain)
            ->setShippingRule($shippingRule)
            ->setShippingTerms($shippingTerms)
            ->setShippingZoneID($shippingZoneID)
            ->setShipVia($shipVia)
            ->setStatementCycleID($statementCycleID)
            ->setStatementType($statementType)
            ->setStatus($status)
            ->setTaxRegistrationID($taxRegistrationID)
            ->setTaxZone($taxZone)
            ->setTerms($terms)
            ->setUnreleasedBalance($unreleasedBalance)
            ->setWarehouseID($warehouseID)
            ->setWriteOffLimit($writeOffLimit);
    }
    /**
     * Get AccountRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccountRef()
    {
        return isset($this->AccountRef) ? $this->AccountRef : null;
    }
    /**
     * Set AccountRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $accountRef
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setAccountRef(\AcumaticaConfig\StructType\StringValue $accountRef = null)
    {
        if (is_null($accountRef) || (is_array($accountRef) && empty($accountRef))) {
            unset($this->AccountRef);
        } else {
            $this->AccountRef = $accountRef;
        }
        return $this;
    }
    /**
     * Get ApplyOverdueCharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getApplyOverdueCharges()
    {
        return isset($this->ApplyOverdueCharges) ? $this->ApplyOverdueCharges : null;
    }
    /**
     * Set ApplyOverdueCharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $applyOverdueCharges
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setApplyOverdueCharges(\AcumaticaConfig\StructType\BooleanValue $applyOverdueCharges = null)
    {
        if (is_null($applyOverdueCharges) || (is_array($applyOverdueCharges) && empty($applyOverdueCharges))) {
            unset($this->ApplyOverdueCharges);
        } else {
            $this->ApplyOverdueCharges = $applyOverdueCharges;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setAttributes(\AcumaticaConfig\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get AutoApplyPayments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getAutoApplyPayments()
    {
        return isset($this->AutoApplyPayments) ? $this->AutoApplyPayments : null;
    }
    /**
     * Set AutoApplyPayments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $autoApplyPayments
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setAutoApplyPayments(\AcumaticaConfig\StructType\BooleanValue $autoApplyPayments = null)
    {
        if (is_null($autoApplyPayments) || (is_array($autoApplyPayments) && empty($autoApplyPayments))) {
            unset($this->AutoApplyPayments);
        } else {
            $this->AutoApplyPayments = $autoApplyPayments;
        }
        return $this;
    }
    /**
     * Get BillingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillingAddressSameAsMain()
    {
        return isset($this->BillingAddressSameAsMain) ? $this->BillingAddressSameAsMain : null;
    }
    /**
     * Set BillingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billingAddressSameAsMain
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setBillingAddressSameAsMain(\AcumaticaConfig\StructType\BooleanValue $billingAddressSameAsMain = null)
    {
        if (is_null($billingAddressSameAsMain) || (is_array($billingAddressSameAsMain) && empty($billingAddressSameAsMain))) {
            unset($this->BillingAddressSameAsMain);
        } else {
            $this->BillingAddressSameAsMain = $billingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get BillingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contact|null
     */
    public function getBillingContact()
    {
        return isset($this->BillingContact) ? $this->BillingContact : null;
    }
    /**
     * Set BillingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contact $billingContact
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setBillingContact(\AcumaticaConfig\StructType\Contact $billingContact = null)
    {
        if (is_null($billingContact) || (is_array($billingContact) && empty($billingContact))) {
            unset($this->BillingContact);
        } else {
            $this->BillingContact = $billingContact;
        }
        return $this;
    }
    /**
     * Get BillingContactSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillingContactSameAsMain()
    {
        return isset($this->BillingContactSameAsMain) ? $this->BillingContactSameAsMain : null;
    }
    /**
     * Set BillingContactSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billingContactSameAsMain
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setBillingContactSameAsMain(\AcumaticaConfig\StructType\BooleanValue $billingContactSameAsMain = null)
    {
        if (is_null($billingContactSameAsMain) || (is_array($billingContactSameAsMain) && empty($billingContactSameAsMain))) {
            unset($this->BillingContactSameAsMain);
        } else {
            $this->BillingContactSameAsMain = $billingContactSameAsMain;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contacts $contacts
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setContacts(\AcumaticaConfig\StructType\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCreatedDateTime(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CreditDaysPastDue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getCreditDaysPastDue()
    {
        return isset($this->CreditDaysPastDue) ? $this->CreditDaysPastDue : null;
    }
    /**
     * Set CreditDaysPastDue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $creditDaysPastDue
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCreditDaysPastDue(\AcumaticaConfig\StructType\ShortValue $creditDaysPastDue = null)
    {
        if (is_null($creditDaysPastDue) || (is_array($creditDaysPastDue) && empty($creditDaysPastDue))) {
            unset($this->CreditDaysPastDue);
        } else {
            $this->CreditDaysPastDue = $creditDaysPastDue;
        }
        return $this;
    }
    /**
     * Get CreditLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCreditLimit()
    {
        return isset($this->CreditLimit) ? $this->CreditLimit : null;
    }
    /**
     * Set CreditLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $creditLimit
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCreditLimit(\AcumaticaConfig\StructType\DecimalValue $creditLimit = null)
    {
        if (is_null($creditLimit) || (is_array($creditLimit) && empty($creditLimit))) {
            unset($this->CreditLimit);
        } else {
            $this->CreditLimit = $creditLimit;
        }
        return $this;
    }
    /**
     * Get CreditVerification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCreditVerification()
    {
        return isset($this->CreditVerification) ? $this->CreditVerification : null;
    }
    /**
     * Set CreditVerification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $creditVerification
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCreditVerification(\AcumaticaConfig\StructType\StringValue $creditVerification = null)
    {
        if (is_null($creditVerification) || (is_array($creditVerification) && empty($creditVerification))) {
            unset($this->CreditVerification);
        } else {
            $this->CreditVerification = $creditVerification;
        }
        return $this;
    }
    /**
     * Get CreditVerificationRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CreditVerificationRules|null
     */
    public function getCreditVerificationRules()
    {
        return isset($this->CreditVerificationRules) ? $this->CreditVerificationRules : null;
    }
    /**
     * Set CreditVerificationRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\CreditVerificationRules $creditVerificationRules
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCreditVerificationRules(\AcumaticaConfig\StructType\CreditVerificationRules $creditVerificationRules = null)
    {
        if (is_null($creditVerificationRules) || (is_array($creditVerificationRules) && empty($creditVerificationRules))) {
            unset($this->CreditVerificationRules);
        } else {
            $this->CreditVerificationRules = $creditVerificationRules;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCurrencyID(\AcumaticaConfig\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyRateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyRateType()
    {
        return isset($this->CurrencyRateType) ? $this->CurrencyRateType : null;
    }
    /**
     * Set CurrencyRateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyRateType
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCurrencyRateType(\AcumaticaConfig\StructType\StringValue $currencyRateType = null)
    {
        if (is_null($currencyRateType) || (is_array($currencyRateType) && empty($currencyRateType))) {
            unset($this->CurrencyRateType);
        } else {
            $this->CurrencyRateType = $currencyRateType;
        }
        return $this;
    }
    /**
     * Get CustomerClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerClass()
    {
        return isset($this->CustomerClass) ? $this->CustomerClass : null;
    }
    /**
     * Set CustomerClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerClass
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCustomerClass(\AcumaticaConfig\StructType\StringValue $customerClass = null)
    {
        if (is_null($customerClass) || (is_array($customerClass) && empty($customerClass))) {
            unset($this->CustomerClass);
        } else {
            $this->CustomerClass = $customerClass;
        }
        return $this;
    }
    /**
     * Get CustomerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerID()
    {
        return isset($this->CustomerID) ? $this->CustomerID : null;
    }
    /**
     * Set CustomerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerID
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCustomerID(\AcumaticaConfig\StructType\StringValue $customerID = null)
    {
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->CustomerID);
        } else {
            $this->CustomerID = $customerID;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $customerName
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setCustomerName(\AcumaticaConfig\StructType\StringValue $customerName = null)
    {
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
    /**
     * Get EnableCurrencyOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getEnableCurrencyOverride()
    {
        return isset($this->EnableCurrencyOverride) ? $this->EnableCurrencyOverride : null;
    }
    /**
     * Set EnableCurrencyOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setEnableCurrencyOverride(\AcumaticaConfig\StructType\BooleanValue $enableCurrencyOverride = null)
    {
        if (is_null($enableCurrencyOverride) || (is_array($enableCurrencyOverride) && empty($enableCurrencyOverride))) {
            unset($this->EnableCurrencyOverride);
        } else {
            $this->EnableCurrencyOverride = $enableCurrencyOverride;
        }
        return $this;
    }
    /**
     * Get EnableRateOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getEnableRateOverride()
    {
        return isset($this->EnableRateOverride) ? $this->EnableRateOverride : null;
    }
    /**
     * Set EnableRateOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $enableRateOverride
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setEnableRateOverride(\AcumaticaConfig\StructType\BooleanValue $enableRateOverride = null)
    {
        if (is_null($enableRateOverride) || (is_array($enableRateOverride) && empty($enableRateOverride))) {
            unset($this->EnableRateOverride);
        } else {
            $this->EnableRateOverride = $enableRateOverride;
        }
        return $this;
    }
    /**
     * Get EnableWriteOffs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getEnableWriteOffs()
    {
        return isset($this->EnableWriteOffs) ? $this->EnableWriteOffs : null;
    }
    /**
     * Set EnableWriteOffs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $enableWriteOffs
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setEnableWriteOffs(\AcumaticaConfig\StructType\BooleanValue $enableWriteOffs = null)
    {
        if (is_null($enableWriteOffs) || (is_array($enableWriteOffs) && empty($enableWriteOffs))) {
            unset($this->EnableWriteOffs);
        } else {
            $this->EnableWriteOffs = $enableWriteOffs;
        }
        return $this;
    }
    /**
     * Get FirstDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getFirstDueDate()
    {
        return isset($this->FirstDueDate) ? $this->FirstDueDate : null;
    }
    /**
     * Set FirstDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $firstDueDate
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setFirstDueDate(\AcumaticaConfig\StructType\DateTimeValue $firstDueDate = null)
    {
        if (is_null($firstDueDate) || (is_array($firstDueDate) && empty($firstDueDate))) {
            unset($this->FirstDueDate);
        } else {
            $this->FirstDueDate = $firstDueDate;
        }
        return $this;
    }
    /**
     * Get FOBPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFOBPoint()
    {
        return isset($this->FOBPoint) ? $this->FOBPoint : null;
    }
    /**
     * Set FOBPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $fOBPoint
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setFOBPoint(\AcumaticaConfig\StructType\StringValue $fOBPoint = null)
    {
        if (is_null($fOBPoint) || (is_array($fOBPoint) && empty($fOBPoint))) {
            unset($this->FOBPoint);
        } else {
            $this->FOBPoint = $fOBPoint;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get LeadTimedays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getLeadTimedays()
    {
        return isset($this->LeadTimedays) ? $this->LeadTimedays : null;
    }
    /**
     * Set LeadTimedays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $leadTimedays
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setLeadTimedays(\AcumaticaConfig\StructType\ShortValue $leadTimedays = null)
    {
        if (is_null($leadTimedays) || (is_array($leadTimedays) && empty($leadTimedays))) {
            unset($this->LeadTimedays);
        } else {
            $this->LeadTimedays = $leadTimedays;
        }
        return $this;
    }
    /**
     * Get LocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLocationName()
    {
        return isset($this->LocationName) ? $this->LocationName : null;
    }
    /**
     * Set LocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $locationName
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setLocationName(\AcumaticaConfig\StructType\StringValue $locationName = null)
    {
        if (is_null($locationName) || (is_array($locationName) && empty($locationName))) {
            unset($this->LocationName);
        } else {
            $this->LocationName = $locationName;
        }
        return $this;
    }
    /**
     * Get MainContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contact|null
     */
    public function getMainContact()
    {
        return isset($this->MainContact) ? $this->MainContact : null;
    }
    /**
     * Set MainContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contact $mainContact
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setMainContact(\AcumaticaConfig\StructType\Contact $mainContact = null)
    {
        if (is_null($mainContact) || (is_array($mainContact) && empty($mainContact))) {
            unset($this->MainContact);
        } else {
            $this->MainContact = $mainContact;
        }
        return $this;
    }
    /**
     * Get MultiCurrencyStatements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getMultiCurrencyStatements()
    {
        return isset($this->MultiCurrencyStatements) ? $this->MultiCurrencyStatements : null;
    }
    /**
     * Set MultiCurrencyStatements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $multiCurrencyStatements
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setMultiCurrencyStatements(\AcumaticaConfig\StructType\BooleanValue $multiCurrencyStatements = null)
    {
        if (is_null($multiCurrencyStatements) || (is_array($multiCurrencyStatements) && empty($multiCurrencyStatements))) {
            unset($this->MultiCurrencyStatements);
        } else {
            $this->MultiCurrencyStatements = $multiCurrencyStatements;
        }
        return $this;
    }
    /**
     * Get OpenOrdersBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getOpenOrdersBalance()
    {
        return isset($this->OpenOrdersBalance) ? $this->OpenOrdersBalance : null;
    }
    /**
     * Set OpenOrdersBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $openOrdersBalance
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setOpenOrdersBalance(\AcumaticaConfig\StructType\DecimalValue $openOrdersBalance = null)
    {
        if (is_null($openOrdersBalance) || (is_array($openOrdersBalance) && empty($openOrdersBalance))) {
            unset($this->OpenOrdersBalance);
        } else {
            $this->OpenOrdersBalance = $openOrdersBalance;
        }
        return $this;
    }
    /**
     * Get OrderPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShortValue|null
     */
    public function getOrderPriority()
    {
        return isset($this->OrderPriority) ? $this->OrderPriority : null;
    }
    /**
     * Set OrderPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\ShortValue $orderPriority
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setOrderPriority(\AcumaticaConfig\StructType\ShortValue $orderPriority = null)
    {
        if (is_null($orderPriority) || (is_array($orderPriority) && empty($orderPriority))) {
            unset($this->OrderPriority);
        } else {
            $this->OrderPriority = $orderPriority;
        }
        return $this;
    }
    /**
     * Get ParentRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getParentRecord()
    {
        return isset($this->ParentRecord) ? $this->ParentRecord : null;
    }
    /**
     * Set ParentRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $parentRecord
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setParentRecord(\AcumaticaConfig\StructType\StringValue $parentRecord = null)
    {
        if (is_null($parentRecord) || (is_array($parentRecord) && empty($parentRecord))) {
            unset($this->ParentRecord);
        } else {
            $this->ParentRecord = $parentRecord;
        }
        return $this;
    }
    /**
     * Get PaymentInstructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PaymentInstructions|null
     */
    public function getPaymentInstructions()
    {
        return isset($this->PaymentInstructions) ? $this->PaymentInstructions : null;
    }
    /**
     * Set PaymentInstructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setPaymentInstructions(\AcumaticaConfig\StructType\PaymentInstructions $paymentInstructions = null)
    {
        if (is_null($paymentInstructions) || (is_array($paymentInstructions) && empty($paymentInstructions))) {
            unset($this->PaymentInstructions);
        } else {
            $this->PaymentInstructions = $paymentInstructions;
        }
        return $this;
    }
    /**
     * Get PriceClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPriceClassID()
    {
        return isset($this->PriceClassID) ? $this->PriceClassID : null;
    }
    /**
     * Set PriceClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $priceClassID
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setPriceClassID(\AcumaticaConfig\StructType\StringValue $priceClassID = null)
    {
        if (is_null($priceClassID) || (is_array($priceClassID) && empty($priceClassID))) {
            unset($this->PriceClassID);
        } else {
            $this->PriceClassID = $priceClassID;
        }
        return $this;
    }
    /**
     * Get PrintDunningLetters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getPrintDunningLetters()
    {
        return isset($this->PrintDunningLetters) ? $this->PrintDunningLetters : null;
    }
    /**
     * Set PrintDunningLetters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $printDunningLetters
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setPrintDunningLetters(\AcumaticaConfig\StructType\BooleanValue $printDunningLetters = null)
    {
        if (is_null($printDunningLetters) || (is_array($printDunningLetters) && empty($printDunningLetters))) {
            unset($this->PrintDunningLetters);
        } else {
            $this->PrintDunningLetters = $printDunningLetters;
        }
        return $this;
    }
    /**
     * Get PrintInvoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getPrintInvoices()
    {
        return isset($this->PrintInvoices) ? $this->PrintInvoices : null;
    }
    /**
     * Set PrintInvoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $printInvoices
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setPrintInvoices(\AcumaticaConfig\StructType\BooleanValue $printInvoices = null)
    {
        if (is_null($printInvoices) || (is_array($printInvoices) && empty($printInvoices))) {
            unset($this->PrintInvoices);
        } else {
            $this->PrintInvoices = $printInvoices;
        }
        return $this;
    }
    /**
     * Get PrintStatements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getPrintStatements()
    {
        return isset($this->PrintStatements) ? $this->PrintStatements : null;
    }
    /**
     * Set PrintStatements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $printStatements
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setPrintStatements(\AcumaticaConfig\StructType\BooleanValue $printStatements = null)
    {
        if (is_null($printStatements) || (is_array($printStatements) && empty($printStatements))) {
            unset($this->PrintStatements);
        } else {
            $this->PrintStatements = $printStatements;
        }
        return $this;
    }
    /**
     * Get RemainingCreditLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getRemainingCreditLimit()
    {
        return isset($this->RemainingCreditLimit) ? $this->RemainingCreditLimit : null;
    }
    /**
     * Set RemainingCreditLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $remainingCreditLimit
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setRemainingCreditLimit(\AcumaticaConfig\StructType\DecimalValue $remainingCreditLimit = null)
    {
        if (is_null($remainingCreditLimit) || (is_array($remainingCreditLimit) && empty($remainingCreditLimit))) {
            unset($this->RemainingCreditLimit);
        } else {
            $this->RemainingCreditLimit = $remainingCreditLimit;
        }
        return $this;
    }
    /**
     * Get ResidentialDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getResidentialDelivery()
    {
        return isset($this->ResidentialDelivery) ? $this->ResidentialDelivery : null;
    }
    /**
     * Set ResidentialDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $residentialDelivery
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setResidentialDelivery(\AcumaticaConfig\StructType\BooleanValue $residentialDelivery = null)
    {
        if (is_null($residentialDelivery) || (is_array($residentialDelivery) && empty($residentialDelivery))) {
            unset($this->ResidentialDelivery);
        } else {
            $this->ResidentialDelivery = $residentialDelivery;
        }
        return $this;
    }
    /**
     * Get Salespersons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Salespersons|null
     */
    public function getSalespersons()
    {
        return isset($this->Salespersons) ? $this->Salespersons : null;
    }
    /**
     * Set Salespersons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Salespersons $salespersons
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setSalespersons(\AcumaticaConfig\StructType\Salespersons $salespersons = null)
    {
        if (is_null($salespersons) || (is_array($salespersons) && empty($salespersons))) {
            unset($this->Salespersons);
        } else {
            $this->Salespersons = $salespersons;
        }
        return $this;
    }
    /**
     * Get SaturdayDelivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSaturdayDelivery()
    {
        return isset($this->SaturdayDelivery) ? $this->SaturdayDelivery : null;
    }
    /**
     * Set SaturdayDelivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $saturdayDelivery
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setSaturdayDelivery(\AcumaticaConfig\StructType\BooleanValue $saturdayDelivery = null)
    {
        if (is_null($saturdayDelivery) || (is_array($saturdayDelivery) && empty($saturdayDelivery))) {
            unset($this->SaturdayDelivery);
        } else {
            $this->SaturdayDelivery = $saturdayDelivery;
        }
        return $this;
    }
    /**
     * Get SendDunningLettersbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSendDunningLettersbyEmail()
    {
        return isset($this->SendDunningLettersbyEmail) ? $this->SendDunningLettersbyEmail : null;
    }
    /**
     * Set SendDunningLettersbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $sendDunningLettersbyEmail
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setSendDunningLettersbyEmail(\AcumaticaConfig\StructType\BooleanValue $sendDunningLettersbyEmail = null)
    {
        if (is_null($sendDunningLettersbyEmail) || (is_array($sendDunningLettersbyEmail) && empty($sendDunningLettersbyEmail))) {
            unset($this->SendDunningLettersbyEmail);
        } else {
            $this->SendDunningLettersbyEmail = $sendDunningLettersbyEmail;
        }
        return $this;
    }
    /**
     * Get SendInvoicesbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSendInvoicesbyEmail()
    {
        return isset($this->SendInvoicesbyEmail) ? $this->SendInvoicesbyEmail : null;
    }
    /**
     * Set SendInvoicesbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $sendInvoicesbyEmail
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setSendInvoicesbyEmail(\AcumaticaConfig\StructType\BooleanValue $sendInvoicesbyEmail = null)
    {
        if (is_null($sendInvoicesbyEmail) || (is_array($sendInvoicesbyEmail) && empty($sendInvoicesbyEmail))) {
            unset($this->SendInvoicesbyEmail);
        } else {
            $this->SendInvoicesbyEmail = $sendInvoicesbyEmail;
        }
        return $this;
    }
    /**
     * Get SendStatementsbyEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getSendStatementsbyEmail()
    {
        return isset($this->SendStatementsbyEmail) ? $this->SendStatementsbyEmail : null;
    }
    /**
     * Set SendStatementsbyEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $sendStatementsbyEmail
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setSendStatementsbyEmail(\AcumaticaConfig\StructType\BooleanValue $sendStatementsbyEmail = null)
    {
        if (is_null($sendStatementsbyEmail) || (is_array($sendStatementsbyEmail) && empty($sendStatementsbyEmail))) {
            unset($this->SendStatementsbyEmail);
        } else {
            $this->SendStatementsbyEmail = $sendStatementsbyEmail;
        }
        return $this;
    }
    /**
     * Get ShippingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShippingAddressSameAsMain()
    {
        return isset($this->ShippingAddressSameAsMain) ? $this->ShippingAddressSameAsMain : null;
    }
    /**
     * Set ShippingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShippingAddressSameAsMain(\AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain = null)
    {
        if (is_null($shippingAddressSameAsMain) || (is_array($shippingAddressSameAsMain) && empty($shippingAddressSameAsMain))) {
            unset($this->ShippingAddressSameAsMain);
        } else {
            $this->ShippingAddressSameAsMain = $shippingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingBranch()
    {
        return isset($this->ShippingBranch) ? $this->ShippingBranch : null;
    }
    /**
     * Set ShippingBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingBranch
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShippingBranch(\AcumaticaConfig\StructType\StringValue $shippingBranch = null)
    {
        if (is_null($shippingBranch) || (is_array($shippingBranch) && empty($shippingBranch))) {
            unset($this->ShippingBranch);
        } else {
            $this->ShippingBranch = $shippingBranch;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contact $shippingContact
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShippingContact(\AcumaticaConfig\StructType\Contact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get ShippingContactSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShippingContactSameAsMain()
    {
        return isset($this->ShippingContactSameAsMain) ? $this->ShippingContactSameAsMain : null;
    }
    /**
     * Set ShippingContactSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingContactSameAsMain
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShippingContactSameAsMain(\AcumaticaConfig\StructType\BooleanValue $shippingContactSameAsMain = null)
    {
        if (is_null($shippingContactSameAsMain) || (is_array($shippingContactSameAsMain) && empty($shippingContactSameAsMain))) {
            unset($this->ShippingContactSameAsMain);
        } else {
            $this->ShippingContactSameAsMain = $shippingContactSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingRule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingRule()
    {
        return isset($this->ShippingRule) ? $this->ShippingRule : null;
    }
    /**
     * Set ShippingRule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingRule
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShippingRule(\AcumaticaConfig\StructType\StringValue $shippingRule = null)
    {
        if (is_null($shippingRule) || (is_array($shippingRule) && empty($shippingRule))) {
            unset($this->ShippingRule);
        } else {
            $this->ShippingRule = $shippingRule;
        }
        return $this;
    }
    /**
     * Get ShippingTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingTerms()
    {
        return isset($this->ShippingTerms) ? $this->ShippingTerms : null;
    }
    /**
     * Set ShippingTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingTerms
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShippingTerms(\AcumaticaConfig\StructType\StringValue $shippingTerms = null)
    {
        if (is_null($shippingTerms) || (is_array($shippingTerms) && empty($shippingTerms))) {
            unset($this->ShippingTerms);
        } else {
            $this->ShippingTerms = $shippingTerms;
        }
        return $this;
    }
    /**
     * Get ShippingZoneID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShippingZoneID()
    {
        return isset($this->ShippingZoneID) ? $this->ShippingZoneID : null;
    }
    /**
     * Set ShippingZoneID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shippingZoneID
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShippingZoneID(\AcumaticaConfig\StructType\StringValue $shippingZoneID = null)
    {
        if (is_null($shippingZoneID) || (is_array($shippingZoneID) && empty($shippingZoneID))) {
            unset($this->ShippingZoneID);
        } else {
            $this->ShippingZoneID = $shippingZoneID;
        }
        return $this;
    }
    /**
     * Get ShipVia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getShipVia()
    {
        return isset($this->ShipVia) ? $this->ShipVia : null;
    }
    /**
     * Set ShipVia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $shipVia
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setShipVia(\AcumaticaConfig\StructType\StringValue $shipVia = null)
    {
        if (is_null($shipVia) || (is_array($shipVia) && empty($shipVia))) {
            unset($this->ShipVia);
        } else {
            $this->ShipVia = $shipVia;
        }
        return $this;
    }
    /**
     * Get StatementCycleID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatementCycleID()
    {
        return isset($this->StatementCycleID) ? $this->StatementCycleID : null;
    }
    /**
     * Set StatementCycleID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $statementCycleID
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setStatementCycleID(\AcumaticaConfig\StructType\StringValue $statementCycleID = null)
    {
        if (is_null($statementCycleID) || (is_array($statementCycleID) && empty($statementCycleID))) {
            unset($this->StatementCycleID);
        } else {
            $this->StatementCycleID = $statementCycleID;
        }
        return $this;
    }
    /**
     * Get StatementType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatementType()
    {
        return isset($this->StatementType) ? $this->StatementType : null;
    }
    /**
     * Set StatementType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $statementType
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setStatementType(\AcumaticaConfig\StructType\StringValue $statementType = null)
    {
        if (is_null($statementType) || (is_array($statementType) && empty($statementType))) {
            unset($this->StatementType);
        } else {
            $this->StatementType = $statementType;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxRegistrationID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxRegistrationID()
    {
        return isset($this->TaxRegistrationID) ? $this->TaxRegistrationID : null;
    }
    /**
     * Set TaxRegistrationID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxRegistrationID
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setTaxRegistrationID(\AcumaticaConfig\StructType\StringValue $taxRegistrationID = null)
    {
        if (is_null($taxRegistrationID) || (is_array($taxRegistrationID) && empty($taxRegistrationID))) {
            unset($this->TaxRegistrationID);
        } else {
            $this->TaxRegistrationID = $taxRegistrationID;
        }
        return $this;
    }
    /**
     * Get TaxZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxZone()
    {
        return isset($this->TaxZone) ? $this->TaxZone : null;
    }
    /**
     * Set TaxZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxZone
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setTaxZone(\AcumaticaConfig\StructType\StringValue $taxZone = null)
    {
        if (is_null($taxZone) || (is_array($taxZone) && empty($taxZone))) {
            unset($this->TaxZone);
        } else {
            $this->TaxZone = $taxZone;
        }
        return $this;
    }
    /**
     * Get Terms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTerms()
    {
        return isset($this->Terms) ? $this->Terms : null;
    }
    /**
     * Set Terms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $terms
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setTerms(\AcumaticaConfig\StructType\StringValue $terms = null)
    {
        if (is_null($terms) || (is_array($terms) && empty($terms))) {
            unset($this->Terms);
        } else {
            $this->Terms = $terms;
        }
        return $this;
    }
    /**
     * Get UnreleasedBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getUnreleasedBalance()
    {
        return isset($this->UnreleasedBalance) ? $this->UnreleasedBalance : null;
    }
    /**
     * Set UnreleasedBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $unreleasedBalance
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setUnreleasedBalance(\AcumaticaConfig\StructType\DecimalValue $unreleasedBalance = null)
    {
        if (is_null($unreleasedBalance) || (is_array($unreleasedBalance) && empty($unreleasedBalance))) {
            unset($this->UnreleasedBalance);
        } else {
            $this->UnreleasedBalance = $unreleasedBalance;
        }
        return $this;
    }
    /**
     * Get WarehouseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWarehouseID()
    {
        return isset($this->WarehouseID) ? $this->WarehouseID : null;
    }
    /**
     * Set WarehouseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $warehouseID
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setWarehouseID(\AcumaticaConfig\StructType\StringValue $warehouseID = null)
    {
        if (is_null($warehouseID) || (is_array($warehouseID) && empty($warehouseID))) {
            unset($this->WarehouseID);
        } else {
            $this->WarehouseID = $warehouseID;
        }
        return $this;
    }
    /**
     * Get WriteOffLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getWriteOffLimit()
    {
        return isset($this->WriteOffLimit) ? $this->WriteOffLimit : null;
    }
    /**
     * Set WriteOffLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $writeOffLimit
     * @return \AcumaticaConfig\StructType\Customer
     */
    public function setWriteOffLimit(\AcumaticaConfig\StructType\DecimalValue $writeOffLimit = null)
    {
        if (is_null($writeOffLimit) || (is_array($writeOffLimit) && empty($writeOffLimit))) {
            unset($this->WriteOffLimit);
        } else {
            $this->WriteOffLimit = $writeOffLimit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
