<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrossSells StructType
 * @subpackage Structs
 */
class CrossSells extends Entity
{
    /**
     * The CrossSells
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CrossSells[]
     */
    public $CrossSells;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The InventoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $InventoryID;
    /**
     * Constructor method for CrossSells
     * @uses CrossSells::setCrossSells()
     * @uses CrossSells::setDescription()
     * @uses CrossSells::setInventoryID()
     * @param \AcumaticaConfig\StructType\CrossSells[] $crossSells
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     */
    public function __construct(array $crossSells = array(), \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        $this
            ->setCrossSells($crossSells)
            ->setDescription($description)
            ->setInventoryID($inventoryID);
    }
    /**
     * Get CrossSells value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CrossSells[]|null
     */
    public function getCrossSells()
    {
        return isset($this->CrossSells) ? $this->CrossSells : null;
    }
    /**
     * Set CrossSells value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CrossSells[] $crossSells
     * @return \AcumaticaConfig\StructType\CrossSells
     */
    public function setCrossSells(array $crossSells = array())
    {
        foreach ($crossSells as $crossSellsCrossSellsItem) {
            // validation for constraint: itemType
            if (!$crossSellsCrossSellsItem instanceof \AcumaticaConfig\StructType\CrossSells) {
                throw new \InvalidArgumentException(sprintf('The CrossSells property can only contain items of \AcumaticaConfig\StructType\CrossSells, "%s" given', is_object($crossSellsCrossSellsItem) ? get_class($crossSellsCrossSellsItem) : gettype($crossSellsCrossSellsItem)), __LINE__);
            }
        }
        if (is_null($crossSells) || (is_array($crossSells) && empty($crossSells))) {
            unset($this->CrossSells);
        } else {
            $this->CrossSells = $crossSells;
        }
        return $this;
    }
    /**
     * Add item to CrossSells value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CrossSells $item
     * @return \AcumaticaConfig\StructType\CrossSells
     */
    public function addToCrossSells(\AcumaticaConfig\StructType\CrossSells $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CrossSells) {
            throw new \InvalidArgumentException(sprintf('The CrossSells property can only contain items of \AcumaticaConfig\StructType\CrossSells, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CrossSells[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\CrossSells
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get InventoryID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getInventoryID()
    {
        return isset($this->InventoryID) ? $this->InventoryID : null;
    }
    /**
     * Set InventoryID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $inventoryID
     * @return \AcumaticaConfig\StructType\CrossSells
     */
    public function setInventoryID(\AcumaticaConfig\StructType\StringValue $inventoryID = null)
    {
        if (is_null($inventoryID) || (is_array($inventoryID) && empty($inventoryID))) {
            unset($this->InventoryID);
        } else {
            $this->InventoryID = $inventoryID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CrossSells
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
