<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrossReferences StructType
 * @subpackage Structs
 */
class CrossReferences extends AbstractStructBase
{
    /**
     * The InventoryItemCrossReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InventoryItemCrossReference[]
     */
    public $InventoryItemCrossReference;
    /**
     * Constructor method for CrossReferences
     * @uses CrossReferences::setInventoryItemCrossReference()
     * @param \AcumaticaConfig\StructType\InventoryItemCrossReference[] $inventoryItemCrossReference
     */
    public function __construct(array $inventoryItemCrossReference = array())
    {
        $this
            ->setInventoryItemCrossReference($inventoryItemCrossReference);
    }
    /**
     * Get InventoryItemCrossReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InventoryItemCrossReference[]|null
     */
    public function getInventoryItemCrossReference()
    {
        return isset($this->InventoryItemCrossReference) ? $this->InventoryItemCrossReference : null;
    }
    /**
     * Set InventoryItemCrossReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryItemCrossReference[] $inventoryItemCrossReference
     * @return \AcumaticaConfig\StructType\CrossReferences
     */
    public function setInventoryItemCrossReference(array $inventoryItemCrossReference = array())
    {
        foreach ($inventoryItemCrossReference as $crossReferencesInventoryItemCrossReferenceItem) {
            // validation for constraint: itemType
            if (!$crossReferencesInventoryItemCrossReferenceItem instanceof \AcumaticaConfig\StructType\InventoryItemCrossReference) {
                throw new \InvalidArgumentException(sprintf('The InventoryItemCrossReference property can only contain items of \AcumaticaConfig\StructType\InventoryItemCrossReference, "%s" given', is_object($crossReferencesInventoryItemCrossReferenceItem) ? get_class($crossReferencesInventoryItemCrossReferenceItem) : gettype($crossReferencesInventoryItemCrossReferenceItem)), __LINE__);
            }
        }
        if (is_null($inventoryItemCrossReference) || (is_array($inventoryItemCrossReference) && empty($inventoryItemCrossReference))) {
            unset($this->InventoryItemCrossReference);
        } else {
            $this->InventoryItemCrossReference = $inventoryItemCrossReference;
        }
        return $this;
    }
    /**
     * Add item to InventoryItemCrossReference value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryItemCrossReference $item
     * @return \AcumaticaConfig\StructType\CrossReferences
     */
    public function addToInventoryItemCrossReference(\AcumaticaConfig\StructType\InventoryItemCrossReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InventoryItemCrossReference) {
            throw new \InvalidArgumentException(sprintf('The InventoryItemCrossReference property can only contain items of \AcumaticaConfig\StructType\InventoryItemCrossReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryItemCrossReference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CrossReferences
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
