<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardProcessingInfo StructType
 * @subpackage Structs
 */
class CreditCardProcessingInfo extends AbstractStructBase
{
    /**
     * The CreditCardProcessingDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CreditCardProcessingDetail[]
     */
    public $CreditCardProcessingDetail;
    /**
     * Constructor method for CreditCardProcessingInfo
     * @uses CreditCardProcessingInfo::setCreditCardProcessingDetail()
     * @param \AcumaticaConfig\StructType\CreditCardProcessingDetail[] $creditCardProcessingDetail
     */
    public function __construct(array $creditCardProcessingDetail = array())
    {
        $this
            ->setCreditCardProcessingDetail($creditCardProcessingDetail);
    }
    /**
     * Get CreditCardProcessingDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CreditCardProcessingDetail[]|null
     */
    public function getCreditCardProcessingDetail()
    {
        return isset($this->CreditCardProcessingDetail) ? $this->CreditCardProcessingDetail : null;
    }
    /**
     * Set CreditCardProcessingDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CreditCardProcessingDetail[] $creditCardProcessingDetail
     * @return \AcumaticaConfig\StructType\CreditCardProcessingInfo
     */
    public function setCreditCardProcessingDetail(array $creditCardProcessingDetail = array())
    {
        foreach ($creditCardProcessingDetail as $creditCardProcessingInfoCreditCardProcessingDetailItem) {
            // validation for constraint: itemType
            if (!$creditCardProcessingInfoCreditCardProcessingDetailItem instanceof \AcumaticaConfig\StructType\CreditCardProcessingDetail) {
                throw new \InvalidArgumentException(sprintf('The CreditCardProcessingDetail property can only contain items of \AcumaticaConfig\StructType\CreditCardProcessingDetail, "%s" given', is_object($creditCardProcessingInfoCreditCardProcessingDetailItem) ? get_class($creditCardProcessingInfoCreditCardProcessingDetailItem) : gettype($creditCardProcessingInfoCreditCardProcessingDetailItem)), __LINE__);
            }
        }
        if (is_null($creditCardProcessingDetail) || (is_array($creditCardProcessingDetail) && empty($creditCardProcessingDetail))) {
            unset($this->CreditCardProcessingDetail);
        } else {
            $this->CreditCardProcessingDetail = $creditCardProcessingDetail;
        }
        return $this;
    }
    /**
     * Add item to CreditCardProcessingDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CreditCardProcessingDetail $item
     * @return \AcumaticaConfig\StructType\CreditCardProcessingInfo
     */
    public function addToCreditCardProcessingDetail(\AcumaticaConfig\StructType\CreditCardProcessingDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CreditCardProcessingDetail) {
            throw new \InvalidArgumentException(sprintf('The CreditCardProcessingDetail property can only contain items of \AcumaticaConfig\StructType\CreditCardProcessingDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CreditCardProcessingDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\CreditCardProcessingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
