<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contacts StructType
 * @subpackage Structs
 */
class Contacts extends AbstractStructBase
{
    /**
     * The CustomerContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CustomerContact[]
     */
    public $CustomerContact;
    /**
     * The BusinessAccountContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountContact[]
     */
    public $BusinessAccountContact;
    /**
     * Constructor method for Contacts
     * @uses Contacts::setCustomerContact()
     * @uses Contacts::setBusinessAccountContact()
     * @param \AcumaticaConfig\StructType\CustomerContact[] $customerContact
     * @param \AcumaticaConfig\StructType\BusinessAccountContact[] $businessAccountContact
     */
    public function __construct(array $customerContact = array(), array $businessAccountContact = array())
    {
        $this
            ->setCustomerContact($customerContact)
            ->setBusinessAccountContact($businessAccountContact);
    }
    /**
     * Get CustomerContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CustomerContact[]|null
     */
    public function getCustomerContact()
    {
        return isset($this->CustomerContact) ? $this->CustomerContact : null;
    }
    /**
     * Set CustomerContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerContact[] $customerContact
     * @return \AcumaticaConfig\StructType\Contacts
     */
    public function setCustomerContact(array $customerContact = array())
    {
        foreach ($customerContact as $contactsCustomerContactItem) {
            // validation for constraint: itemType
            if (!$contactsCustomerContactItem instanceof \AcumaticaConfig\StructType\CustomerContact) {
                throw new \InvalidArgumentException(sprintf('The CustomerContact property can only contain items of \AcumaticaConfig\StructType\CustomerContact, "%s" given', is_object($contactsCustomerContactItem) ? get_class($contactsCustomerContactItem) : gettype($contactsCustomerContactItem)), __LINE__);
            }
        }
        if (is_null($customerContact) || (is_array($customerContact) && empty($customerContact))) {
            unset($this->CustomerContact);
        } else {
            $this->CustomerContact = $customerContact;
        }
        return $this;
    }
    /**
     * Add item to CustomerContact value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CustomerContact $item
     * @return \AcumaticaConfig\StructType\Contacts
     */
    public function addToCustomerContact(\AcumaticaConfig\StructType\CustomerContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CustomerContact) {
            throw new \InvalidArgumentException(sprintf('The CustomerContact property can only contain items of \AcumaticaConfig\StructType\CustomerContact, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerContact[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountContact[]|null
     */
    public function getBusinessAccountContact()
    {
        return isset($this->BusinessAccountContact) ? $this->BusinessAccountContact : null;
    }
    /**
     * Set BusinessAccountContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountContact[] $businessAccountContact
     * @return \AcumaticaConfig\StructType\Contacts
     */
    public function setBusinessAccountContact(array $businessAccountContact = array())
    {
        foreach ($businessAccountContact as $contactsBusinessAccountContactItem) {
            // validation for constraint: itemType
            if (!$contactsBusinessAccountContactItem instanceof \AcumaticaConfig\StructType\BusinessAccountContact) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountContact property can only contain items of \AcumaticaConfig\StructType\BusinessAccountContact, "%s" given', is_object($contactsBusinessAccountContactItem) ? get_class($contactsBusinessAccountContactItem) : gettype($contactsBusinessAccountContactItem)), __LINE__);
            }
        }
        if (is_null($businessAccountContact) || (is_array($businessAccountContact) && empty($businessAccountContact))) {
            unset($this->BusinessAccountContact);
        } else {
            $this->BusinessAccountContact = $businessAccountContact;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountContact value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountContact $item
     * @return \AcumaticaConfig\StructType\Contacts
     */
    public function addToBusinessAccountContact(\AcumaticaConfig\StructType\BusinessAccountContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountContact) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountContact property can only contain items of \AcumaticaConfig\StructType\BusinessAccountContact, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountContact[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Contacts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
