<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Categories StructType
 * @subpackage Structs
 */
class Categories extends AbstractStructBase
{
    /**
     * The CategoryStockItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CategoryStockItem[]
     */
    public $CategoryStockItem;
    /**
     * Constructor method for Categories
     * @uses Categories::setCategoryStockItem()
     * @param \AcumaticaConfig\StructType\CategoryStockItem[] $categoryStockItem
     */
    public function __construct(array $categoryStockItem = array())
    {
        $this
            ->setCategoryStockItem($categoryStockItem);
    }
    /**
     * Get CategoryStockItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CategoryStockItem[]|null
     */
    public function getCategoryStockItem()
    {
        return isset($this->CategoryStockItem) ? $this->CategoryStockItem : null;
    }
    /**
     * Set CategoryStockItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CategoryStockItem[] $categoryStockItem
     * @return \AcumaticaConfig\StructType\Categories
     */
    public function setCategoryStockItem(array $categoryStockItem = array())
    {
        foreach ($categoryStockItem as $categoriesCategoryStockItemItem) {
            // validation for constraint: itemType
            if (!$categoriesCategoryStockItemItem instanceof \AcumaticaConfig\StructType\CategoryStockItem) {
                throw new \InvalidArgumentException(sprintf('The CategoryStockItem property can only contain items of \AcumaticaConfig\StructType\CategoryStockItem, "%s" given', is_object($categoriesCategoryStockItemItem) ? get_class($categoriesCategoryStockItemItem) : gettype($categoriesCategoryStockItemItem)), __LINE__);
            }
        }
        if (is_null($categoryStockItem) || (is_array($categoryStockItem) && empty($categoryStockItem))) {
            unset($this->CategoryStockItem);
        } else {
            $this->CategoryStockItem = $categoryStockItem;
        }
        return $this;
    }
    /**
     * Add item to CategoryStockItem value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CategoryStockItem $item
     * @return \AcumaticaConfig\StructType\Categories
     */
    public function addToCategoryStockItem(\AcumaticaConfig\StructType\CategoryStockItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CategoryStockItem) {
            throw new \InvalidArgumentException(sprintf('The CategoryStockItem property can only contain items of \AcumaticaConfig\StructType\CategoryStockItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CategoryStockItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Categories
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
