<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Carrier StructType
 * @subpackage Structs
 */
class Carrier extends Entity
{
    /**
     * The CarrierID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CarrierID;
    /**
     * The CarrierUnitOfWeight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CarrierUnitOfWeight;
    /**
     * The CreatedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $CreatedDateTime;
    /**
     * The CustomerAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CustomerAccounts
     */
    public $CustomerAccounts;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The LastModifiedDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastModifiedDateTime;
    /**
     * The PlugInParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PlugInParameters
     */
    public $PlugInParameters;
    /**
     * The PlugInType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $PlugInType;
    /**
     * The UOM
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $UOM;
    /**
     * Constructor method for Carrier
     * @uses Carrier::setCarrierID()
     * @uses Carrier::setCarrierUnitOfWeight()
     * @uses Carrier::setCreatedDateTime()
     * @uses Carrier::setCustomerAccounts()
     * @uses Carrier::setDescription()
     * @uses Carrier::setLastModifiedDateTime()
     * @uses Carrier::setPlugInParameters()
     * @uses Carrier::setPlugInType()
     * @uses Carrier::setUOM()
     * @param \AcumaticaConfig\StructType\StringValue $carrierID
     * @param \AcumaticaConfig\StructType\StringValue $carrierUnitOfWeight
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @param \AcumaticaConfig\StructType\CustomerAccounts $customerAccounts
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @param \AcumaticaConfig\StructType\PlugInParameters $plugInParameters
     * @param \AcumaticaConfig\StructType\StringValue $plugInType
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $carrierID = null, \AcumaticaConfig\StructType\StringValue $carrierUnitOfWeight = null, \AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null, \AcumaticaConfig\StructType\CustomerAccounts $customerAccounts = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null, \AcumaticaConfig\StructType\PlugInParameters $plugInParameters = null, \AcumaticaConfig\StructType\StringValue $plugInType = null, \AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        $this
            ->setCarrierID($carrierID)
            ->setCarrierUnitOfWeight($carrierUnitOfWeight)
            ->setCreatedDateTime($createdDateTime)
            ->setCustomerAccounts($customerAccounts)
            ->setDescription($description)
            ->setLastModifiedDateTime($lastModifiedDateTime)
            ->setPlugInParameters($plugInParameters)
            ->setPlugInType($plugInType)
            ->setUOM($uOM);
    }
    /**
     * Get CarrierID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCarrierID()
    {
        return isset($this->CarrierID) ? $this->CarrierID : null;
    }
    /**
     * Set CarrierID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $carrierID
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setCarrierID(\AcumaticaConfig\StructType\StringValue $carrierID = null)
    {
        if (is_null($carrierID) || (is_array($carrierID) && empty($carrierID))) {
            unset($this->CarrierID);
        } else {
            $this->CarrierID = $carrierID;
        }
        return $this;
    }
    /**
     * Get CarrierUnitOfWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCarrierUnitOfWeight()
    {
        return isset($this->CarrierUnitOfWeight) ? $this->CarrierUnitOfWeight : null;
    }
    /**
     * Set CarrierUnitOfWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $carrierUnitOfWeight
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setCarrierUnitOfWeight(\AcumaticaConfig\StructType\StringValue $carrierUnitOfWeight = null)
    {
        if (is_null($carrierUnitOfWeight) || (is_array($carrierUnitOfWeight) && empty($carrierUnitOfWeight))) {
            unset($this->CarrierUnitOfWeight);
        } else {
            $this->CarrierUnitOfWeight = $carrierUnitOfWeight;
        }
        return $this;
    }
    /**
     * Get CreatedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getCreatedDateTime()
    {
        return isset($this->CreatedDateTime) ? $this->CreatedDateTime : null;
    }
    /**
     * Set CreatedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $createdDateTime
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setCreatedDateTime(\AcumaticaConfig\StructType\DateTimeValue $createdDateTime = null)
    {
        if (is_null($createdDateTime) || (is_array($createdDateTime) && empty($createdDateTime))) {
            unset($this->CreatedDateTime);
        } else {
            $this->CreatedDateTime = $createdDateTime;
        }
        return $this;
    }
    /**
     * Get CustomerAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CustomerAccounts|null
     */
    public function getCustomerAccounts()
    {
        return isset($this->CustomerAccounts) ? $this->CustomerAccounts : null;
    }
    /**
     * Set CustomerAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\CustomerAccounts $customerAccounts
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setCustomerAccounts(\AcumaticaConfig\StructType\CustomerAccounts $customerAccounts = null)
    {
        if (is_null($customerAccounts) || (is_array($customerAccounts) && empty($customerAccounts))) {
            unset($this->CustomerAccounts);
        } else {
            $this->CustomerAccounts = $customerAccounts;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get LastModifiedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastModifiedDateTime()
    {
        return isset($this->LastModifiedDateTime) ? $this->LastModifiedDateTime : null;
    }
    /**
     * Set LastModifiedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setLastModifiedDateTime(\AcumaticaConfig\StructType\DateTimeValue $lastModifiedDateTime = null)
    {
        if (is_null($lastModifiedDateTime) || (is_array($lastModifiedDateTime) && empty($lastModifiedDateTime))) {
            unset($this->LastModifiedDateTime);
        } else {
            $this->LastModifiedDateTime = $lastModifiedDateTime;
        }
        return $this;
    }
    /**
     * Get PlugInParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PlugInParameters|null
     */
    public function getPlugInParameters()
    {
        return isset($this->PlugInParameters) ? $this->PlugInParameters : null;
    }
    /**
     * Set PlugInParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\PlugInParameters $plugInParameters
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setPlugInParameters(\AcumaticaConfig\StructType\PlugInParameters $plugInParameters = null)
    {
        if (is_null($plugInParameters) || (is_array($plugInParameters) && empty($plugInParameters))) {
            unset($this->PlugInParameters);
        } else {
            $this->PlugInParameters = $plugInParameters;
        }
        return $this;
    }
    /**
     * Get PlugInType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getPlugInType()
    {
        return isset($this->PlugInType) ? $this->PlugInType : null;
    }
    /**
     * Set PlugInType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $plugInType
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setPlugInType(\AcumaticaConfig\StructType\StringValue $plugInType = null)
    {
        if (is_null($plugInType) || (is_array($plugInType) && empty($plugInType))) {
            unset($this->PlugInType);
        } else {
            $this->PlugInType = $plugInType;
        }
        return $this;
    }
    /**
     * Get UOM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getUOM()
    {
        return isset($this->UOM) ? $this->UOM : null;
    }
    /**
     * Set UOM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $uOM
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public function setUOM(\AcumaticaConfig\StructType\StringValue $uOM = null)
    {
        if (is_null($uOM) || (is_array($uOM) && empty($uOM))) {
            unset($this->UOM);
        } else {
            $this->UOM = $uOM;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Carrier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
