<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusinessAccount StructType
 * @subpackage Structs
 */
class BusinessAccount extends Entity
{
    /**
     * The AccountRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AccountRef;
    /**
     * The Activities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Activities
     */
    public $Activities;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Attributes
     */
    public $Attributes;
    /**
     * The BusinessAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $BusinessAccountID;
    /**
     * The Campaigns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Campaigns
     */
    public $Campaigns;
    /**
     * The Cases
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Cases
     */
    public $Cases;
    /**
     * The ClassID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ClassID;
    /**
     * The Contacts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contacts
     */
    public $Contacts;
    /**
     * The Contracts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Contracts
     */
    public $Contracts;
    /**
     * The DefaultLocationSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountDefaultLocationSetting
     */
    public $DefaultLocationSettings;
    /**
     * The Duplicate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Duplicate;
    /**
     * The Duplicates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Duplicates
     */
    public $Duplicates;
    /**
     * The LastIncomingActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastIncomingActivity;
    /**
     * The LastOutgoingActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $LastOutgoingActivity;
    /**
     * The Locations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Locations
     */
    public $Locations;
    /**
     * The MainAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $MainAddress;
    /**
     * The MainAddressValidated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $MainAddressValidated;
    /**
     * The MainContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountMainContact
     */
    public $MainContact;
    /**
     * The MarketingLists
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\MarketingLists
     */
    public $MarketingLists;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Name;
    /**
     * The Opportunities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Opportunities
     */
    public $Opportunities;
    /**
     * The Orders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Orders
     */
    public $Orders;
    /**
     * The Owner
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Owner;
    /**
     * The OwnerEmployeeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $OwnerEmployeeName;
    /**
     * The ParentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ParentAccount;
    /**
     * The Relations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Relations
     */
    public $Relations;
    /**
     * The ShippingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $ShippingAddress;
    /**
     * The ShippingAddressSameAsMain
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShippingAddressSameAsMain;
    /**
     * The ShippingAddressValidated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $ShippingAddressValidated;
    /**
     * The ShippingContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountShippingContact
     */
    public $ShippingContact;
    /**
     * The SourceCampaign
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $SourceCampaign;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Type;
    /**
     * The Workgroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Workgroup;
    /**
     * The WorkgroupDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $WorkgroupDescription;
    /**
     * Constructor method for BusinessAccount
     * @uses BusinessAccount::setAccountRef()
     * @uses BusinessAccount::setActivities()
     * @uses BusinessAccount::setAttributes()
     * @uses BusinessAccount::setBusinessAccountID()
     * @uses BusinessAccount::setCampaigns()
     * @uses BusinessAccount::setCases()
     * @uses BusinessAccount::setClassID()
     * @uses BusinessAccount::setContacts()
     * @uses BusinessAccount::setContracts()
     * @uses BusinessAccount::setDefaultLocationSettings()
     * @uses BusinessAccount::setDuplicate()
     * @uses BusinessAccount::setDuplicates()
     * @uses BusinessAccount::setLastIncomingActivity()
     * @uses BusinessAccount::setLastOutgoingActivity()
     * @uses BusinessAccount::setLocations()
     * @uses BusinessAccount::setMainAddress()
     * @uses BusinessAccount::setMainAddressValidated()
     * @uses BusinessAccount::setMainContact()
     * @uses BusinessAccount::setMarketingLists()
     * @uses BusinessAccount::setName()
     * @uses BusinessAccount::setOpportunities()
     * @uses BusinessAccount::setOrders()
     * @uses BusinessAccount::setOwner()
     * @uses BusinessAccount::setOwnerEmployeeName()
     * @uses BusinessAccount::setParentAccount()
     * @uses BusinessAccount::setRelations()
     * @uses BusinessAccount::setShippingAddress()
     * @uses BusinessAccount::setShippingAddressSameAsMain()
     * @uses BusinessAccount::setShippingAddressValidated()
     * @uses BusinessAccount::setShippingContact()
     * @uses BusinessAccount::setSourceCampaign()
     * @uses BusinessAccount::setStatus()
     * @uses BusinessAccount::setType()
     * @uses BusinessAccount::setWorkgroup()
     * @uses BusinessAccount::setWorkgroupDescription()
     * @param \AcumaticaConfig\StructType\StringValue $accountRef
     * @param \AcumaticaConfig\StructType\Activities $activities
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @param \AcumaticaConfig\StructType\StringValue $businessAccountID
     * @param \AcumaticaConfig\StructType\Campaigns $campaigns
     * @param \AcumaticaConfig\StructType\Cases $cases
     * @param \AcumaticaConfig\StructType\StringValue $classID
     * @param \AcumaticaConfig\StructType\Contacts $contacts
     * @param \AcumaticaConfig\StructType\Contracts $contracts
     * @param \AcumaticaConfig\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings
     * @param \AcumaticaConfig\StructType\StringValue $duplicate
     * @param \AcumaticaConfig\StructType\Duplicates $duplicates
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastIncomingActivity
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastOutgoingActivity
     * @param \AcumaticaConfig\StructType\Locations $locations
     * @param \AcumaticaConfig\StructType\Address $mainAddress
     * @param \AcumaticaConfig\StructType\BooleanValue $mainAddressValidated
     * @param \AcumaticaConfig\StructType\BusinessAccountMainContact $mainContact
     * @param \AcumaticaConfig\StructType\MarketingLists $marketingLists
     * @param \AcumaticaConfig\StructType\StringValue $name
     * @param \AcumaticaConfig\StructType\Opportunities $opportunities
     * @param \AcumaticaConfig\StructType\Orders $orders
     * @param \AcumaticaConfig\StructType\StringValue $owner
     * @param \AcumaticaConfig\StructType\StringValue $ownerEmployeeName
     * @param \AcumaticaConfig\StructType\StringValue $parentAccount
     * @param \AcumaticaConfig\StructType\Relations $relations
     * @param \AcumaticaConfig\StructType\Address $shippingAddress
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressValidated
     * @param \AcumaticaConfig\StructType\BusinessAccountShippingContact $shippingContact
     * @param \AcumaticaConfig\StructType\StringValue $sourceCampaign
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @param \AcumaticaConfig\StructType\StringValue $workgroup
     * @param \AcumaticaConfig\StructType\StringValue $workgroupDescription
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $accountRef = null, \AcumaticaConfig\StructType\Activities $activities = null, \AcumaticaConfig\StructType\Attributes $attributes = null, \AcumaticaConfig\StructType\StringValue $businessAccountID = null, \AcumaticaConfig\StructType\Campaigns $campaigns = null, \AcumaticaConfig\StructType\Cases $cases = null, \AcumaticaConfig\StructType\StringValue $classID = null, \AcumaticaConfig\StructType\Contacts $contacts = null, \AcumaticaConfig\StructType\Contracts $contracts = null, \AcumaticaConfig\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings = null, \AcumaticaConfig\StructType\StringValue $duplicate = null, \AcumaticaConfig\StructType\Duplicates $duplicates = null, \AcumaticaConfig\StructType\DateTimeValue $lastIncomingActivity = null, \AcumaticaConfig\StructType\DateTimeValue $lastOutgoingActivity = null, \AcumaticaConfig\StructType\Locations $locations = null, \AcumaticaConfig\StructType\Address $mainAddress = null, \AcumaticaConfig\StructType\BooleanValue $mainAddressValidated = null, \AcumaticaConfig\StructType\BusinessAccountMainContact $mainContact = null, \AcumaticaConfig\StructType\MarketingLists $marketingLists = null, \AcumaticaConfig\StructType\StringValue $name = null, \AcumaticaConfig\StructType\Opportunities $opportunities = null, \AcumaticaConfig\StructType\Orders $orders = null, \AcumaticaConfig\StructType\StringValue $owner = null, \AcumaticaConfig\StructType\StringValue $ownerEmployeeName = null, \AcumaticaConfig\StructType\StringValue $parentAccount = null, \AcumaticaConfig\StructType\Relations $relations = null, \AcumaticaConfig\StructType\Address $shippingAddress = null, \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain = null, \AcumaticaConfig\StructType\BooleanValue $shippingAddressValidated = null, \AcumaticaConfig\StructType\BusinessAccountShippingContact $shippingContact = null, \AcumaticaConfig\StructType\StringValue $sourceCampaign = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\StringValue $type = null, \AcumaticaConfig\StructType\StringValue $workgroup = null, \AcumaticaConfig\StructType\StringValue $workgroupDescription = null)
    {
        $this
            ->setAccountRef($accountRef)
            ->setActivities($activities)
            ->setAttributes($attributes)
            ->setBusinessAccountID($businessAccountID)
            ->setCampaigns($campaigns)
            ->setCases($cases)
            ->setClassID($classID)
            ->setContacts($contacts)
            ->setContracts($contracts)
            ->setDefaultLocationSettings($defaultLocationSettings)
            ->setDuplicate($duplicate)
            ->setDuplicates($duplicates)
            ->setLastIncomingActivity($lastIncomingActivity)
            ->setLastOutgoingActivity($lastOutgoingActivity)
            ->setLocations($locations)
            ->setMainAddress($mainAddress)
            ->setMainAddressValidated($mainAddressValidated)
            ->setMainContact($mainContact)
            ->setMarketingLists($marketingLists)
            ->setName($name)
            ->setOpportunities($opportunities)
            ->setOrders($orders)
            ->setOwner($owner)
            ->setOwnerEmployeeName($ownerEmployeeName)
            ->setParentAccount($parentAccount)
            ->setRelations($relations)
            ->setShippingAddress($shippingAddress)
            ->setShippingAddressSameAsMain($shippingAddressSameAsMain)
            ->setShippingAddressValidated($shippingAddressValidated)
            ->setShippingContact($shippingContact)
            ->setSourceCampaign($sourceCampaign)
            ->setStatus($status)
            ->setType($type)
            ->setWorkgroup($workgroup)
            ->setWorkgroupDescription($workgroupDescription);
    }
    /**
     * Get AccountRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccountRef()
    {
        return isset($this->AccountRef) ? $this->AccountRef : null;
    }
    /**
     * Set AccountRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $accountRef
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setAccountRef(\AcumaticaConfig\StructType\StringValue $accountRef = null)
    {
        if (is_null($accountRef) || (is_array($accountRef) && empty($accountRef))) {
            unset($this->AccountRef);
        } else {
            $this->AccountRef = $accountRef;
        }
        return $this;
    }
    /**
     * Get Activities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Activities|null
     */
    public function getActivities()
    {
        return isset($this->Activities) ? $this->Activities : null;
    }
    /**
     * Set Activities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Activities $activities
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setActivities(\AcumaticaConfig\StructType\Activities $activities = null)
    {
        if (is_null($activities) || (is_array($activities) && empty($activities))) {
            unset($this->Activities);
        } else {
            $this->Activities = $activities;
        }
        return $this;
    }
    /**
     * Get Attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Attributes|null
     */
    public function getAttributes()
    {
        return isset($this->Attributes) ? $this->Attributes : null;
    }
    /**
     * Set Attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Attributes $attributes
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setAttributes(\AcumaticaConfig\StructType\Attributes $attributes = null)
    {
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->Attributes);
        } else {
            $this->Attributes = $attributes;
        }
        return $this;
    }
    /**
     * Get BusinessAccountID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBusinessAccountID()
    {
        return isset($this->BusinessAccountID) ? $this->BusinessAccountID : null;
    }
    /**
     * Set BusinessAccountID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $businessAccountID
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setBusinessAccountID(\AcumaticaConfig\StructType\StringValue $businessAccountID = null)
    {
        if (is_null($businessAccountID) || (is_array($businessAccountID) && empty($businessAccountID))) {
            unset($this->BusinessAccountID);
        } else {
            $this->BusinessAccountID = $businessAccountID;
        }
        return $this;
    }
    /**
     * Get Campaigns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Campaigns|null
     */
    public function getCampaigns()
    {
        return isset($this->Campaigns) ? $this->Campaigns : null;
    }
    /**
     * Set Campaigns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Campaigns $campaigns
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setCampaigns(\AcumaticaConfig\StructType\Campaigns $campaigns = null)
    {
        if (is_null($campaigns) || (is_array($campaigns) && empty($campaigns))) {
            unset($this->Campaigns);
        } else {
            $this->Campaigns = $campaigns;
        }
        return $this;
    }
    /**
     * Get Cases value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Cases|null
     */
    public function getCases()
    {
        return isset($this->Cases) ? $this->Cases : null;
    }
    /**
     * Set Cases value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Cases $cases
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setCases(\AcumaticaConfig\StructType\Cases $cases = null)
    {
        if (is_null($cases) || (is_array($cases) && empty($cases))) {
            unset($this->Cases);
        } else {
            $this->Cases = $cases;
        }
        return $this;
    }
    /**
     * Get ClassID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getClassID()
    {
        return isset($this->ClassID) ? $this->ClassID : null;
    }
    /**
     * Set ClassID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $classID
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setClassID(\AcumaticaConfig\StructType\StringValue $classID = null)
    {
        if (is_null($classID) || (is_array($classID) && empty($classID))) {
            unset($this->ClassID);
        } else {
            $this->ClassID = $classID;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contacts $contacts
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setContacts(\AcumaticaConfig\StructType\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get Contracts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Contracts|null
     */
    public function getContracts()
    {
        return isset($this->Contracts) ? $this->Contracts : null;
    }
    /**
     * Set Contracts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Contracts $contracts
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setContracts(\AcumaticaConfig\StructType\Contracts $contracts = null)
    {
        if (is_null($contracts) || (is_array($contracts) && empty($contracts))) {
            unset($this->Contracts);
        } else {
            $this->Contracts = $contracts;
        }
        return $this;
    }
    /**
     * Get DefaultLocationSettings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountDefaultLocationSetting|null
     */
    public function getDefaultLocationSettings()
    {
        return isset($this->DefaultLocationSettings) ? $this->DefaultLocationSettings : null;
    }
    /**
     * Set DefaultLocationSettings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setDefaultLocationSettings(\AcumaticaConfig\StructType\BusinessAccountDefaultLocationSetting $defaultLocationSettings = null)
    {
        if (is_null($defaultLocationSettings) || (is_array($defaultLocationSettings) && empty($defaultLocationSettings))) {
            unset($this->DefaultLocationSettings);
        } else {
            $this->DefaultLocationSettings = $defaultLocationSettings;
        }
        return $this;
    }
    /**
     * Get Duplicate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDuplicate()
    {
        return isset($this->Duplicate) ? $this->Duplicate : null;
    }
    /**
     * Set Duplicate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $duplicate
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setDuplicate(\AcumaticaConfig\StructType\StringValue $duplicate = null)
    {
        if (is_null($duplicate) || (is_array($duplicate) && empty($duplicate))) {
            unset($this->Duplicate);
        } else {
            $this->Duplicate = $duplicate;
        }
        return $this;
    }
    /**
     * Get Duplicates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Duplicates|null
     */
    public function getDuplicates()
    {
        return isset($this->Duplicates) ? $this->Duplicates : null;
    }
    /**
     * Set Duplicates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Duplicates $duplicates
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setDuplicates(\AcumaticaConfig\StructType\Duplicates $duplicates = null)
    {
        if (is_null($duplicates) || (is_array($duplicates) && empty($duplicates))) {
            unset($this->Duplicates);
        } else {
            $this->Duplicates = $duplicates;
        }
        return $this;
    }
    /**
     * Get LastIncomingActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastIncomingActivity()
    {
        return isset($this->LastIncomingActivity) ? $this->LastIncomingActivity : null;
    }
    /**
     * Set LastIncomingActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastIncomingActivity
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setLastIncomingActivity(\AcumaticaConfig\StructType\DateTimeValue $lastIncomingActivity = null)
    {
        if (is_null($lastIncomingActivity) || (is_array($lastIncomingActivity) && empty($lastIncomingActivity))) {
            unset($this->LastIncomingActivity);
        } else {
            $this->LastIncomingActivity = $lastIncomingActivity;
        }
        return $this;
    }
    /**
     * Get LastOutgoingActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getLastOutgoingActivity()
    {
        return isset($this->LastOutgoingActivity) ? $this->LastOutgoingActivity : null;
    }
    /**
     * Set LastOutgoingActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $lastOutgoingActivity
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setLastOutgoingActivity(\AcumaticaConfig\StructType\DateTimeValue $lastOutgoingActivity = null)
    {
        if (is_null($lastOutgoingActivity) || (is_array($lastOutgoingActivity) && empty($lastOutgoingActivity))) {
            unset($this->LastOutgoingActivity);
        } else {
            $this->LastOutgoingActivity = $lastOutgoingActivity;
        }
        return $this;
    }
    /**
     * Get Locations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Locations|null
     */
    public function getLocations()
    {
        return isset($this->Locations) ? $this->Locations : null;
    }
    /**
     * Set Locations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Locations $locations
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setLocations(\AcumaticaConfig\StructType\Locations $locations = null)
    {
        if (is_null($locations) || (is_array($locations) && empty($locations))) {
            unset($this->Locations);
        } else {
            $this->Locations = $locations;
        }
        return $this;
    }
    /**
     * Get MainAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getMainAddress()
    {
        return isset($this->MainAddress) ? $this->MainAddress : null;
    }
    /**
     * Set MainAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $mainAddress
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setMainAddress(\AcumaticaConfig\StructType\Address $mainAddress = null)
    {
        if (is_null($mainAddress) || (is_array($mainAddress) && empty($mainAddress))) {
            unset($this->MainAddress);
        } else {
            $this->MainAddress = $mainAddress;
        }
        return $this;
    }
    /**
     * Get MainAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getMainAddressValidated()
    {
        return isset($this->MainAddressValidated) ? $this->MainAddressValidated : null;
    }
    /**
     * Set MainAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $mainAddressValidated
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setMainAddressValidated(\AcumaticaConfig\StructType\BooleanValue $mainAddressValidated = null)
    {
        if (is_null($mainAddressValidated) || (is_array($mainAddressValidated) && empty($mainAddressValidated))) {
            unset($this->MainAddressValidated);
        } else {
            $this->MainAddressValidated = $mainAddressValidated;
        }
        return $this;
    }
    /**
     * Get MainContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountMainContact|null
     */
    public function getMainContact()
    {
        return isset($this->MainContact) ? $this->MainContact : null;
    }
    /**
     * Set MainContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BusinessAccountMainContact $mainContact
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setMainContact(\AcumaticaConfig\StructType\BusinessAccountMainContact $mainContact = null)
    {
        if (is_null($mainContact) || (is_array($mainContact) && empty($mainContact))) {
            unset($this->MainContact);
        } else {
            $this->MainContact = $mainContact;
        }
        return $this;
    }
    /**
     * Get MarketingLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\MarketingLists|null
     */
    public function getMarketingLists()
    {
        return isset($this->MarketingLists) ? $this->MarketingLists : null;
    }
    /**
     * Set MarketingLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\MarketingLists $marketingLists
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setMarketingLists(\AcumaticaConfig\StructType\MarketingLists $marketingLists = null)
    {
        if (is_null($marketingLists) || (is_array($marketingLists) && empty($marketingLists))) {
            unset($this->MarketingLists);
        } else {
            $this->MarketingLists = $marketingLists;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $name
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setName(\AcumaticaConfig\StructType\StringValue $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Opportunities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Opportunities|null
     */
    public function getOpportunities()
    {
        return isset($this->Opportunities) ? $this->Opportunities : null;
    }
    /**
     * Set Opportunities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Opportunities $opportunities
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setOpportunities(\AcumaticaConfig\StructType\Opportunities $opportunities = null)
    {
        if (is_null($opportunities) || (is_array($opportunities) && empty($opportunities))) {
            unset($this->Opportunities);
        } else {
            $this->Opportunities = $opportunities;
        }
        return $this;
    }
    /**
     * Get Orders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Orders|null
     */
    public function getOrders()
    {
        return isset($this->Orders) ? $this->Orders : null;
    }
    /**
     * Set Orders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Orders $orders
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setOrders(\AcumaticaConfig\StructType\Orders $orders = null)
    {
        if (is_null($orders) || (is_array($orders) && empty($orders))) {
            unset($this->Orders);
        } else {
            $this->Orders = $orders;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $owner
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setOwner(\AcumaticaConfig\StructType\StringValue $owner = null)
    {
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerEmployeeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getOwnerEmployeeName()
    {
        return isset($this->OwnerEmployeeName) ? $this->OwnerEmployeeName : null;
    }
    /**
     * Set OwnerEmployeeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $ownerEmployeeName
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setOwnerEmployeeName(\AcumaticaConfig\StructType\StringValue $ownerEmployeeName = null)
    {
        if (is_null($ownerEmployeeName) || (is_array($ownerEmployeeName) && empty($ownerEmployeeName))) {
            unset($this->OwnerEmployeeName);
        } else {
            $this->OwnerEmployeeName = $ownerEmployeeName;
        }
        return $this;
    }
    /**
     * Get ParentAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getParentAccount()
    {
        return isset($this->ParentAccount) ? $this->ParentAccount : null;
    }
    /**
     * Set ParentAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $parentAccount
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setParentAccount(\AcumaticaConfig\StructType\StringValue $parentAccount = null)
    {
        if (is_null($parentAccount) || (is_array($parentAccount) && empty($parentAccount))) {
            unset($this->ParentAccount);
        } else {
            $this->ParentAccount = $parentAccount;
        }
        return $this;
    }
    /**
     * Get Relations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Relations|null
     */
    public function getRelations()
    {
        return isset($this->Relations) ? $this->Relations : null;
    }
    /**
     * Set Relations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Relations $relations
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setRelations(\AcumaticaConfig\StructType\Relations $relations = null)
    {
        if (is_null($relations) || (is_array($relations) && empty($relations))) {
            unset($this->Relations);
        } else {
            $this->Relations = $relations;
        }
        return $this;
    }
    /**
     * Get ShippingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getShippingAddress()
    {
        return isset($this->ShippingAddress) ? $this->ShippingAddress : null;
    }
    /**
     * Set ShippingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $shippingAddress
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setShippingAddress(\AcumaticaConfig\StructType\Address $shippingAddress = null)
    {
        if (is_null($shippingAddress) || (is_array($shippingAddress) && empty($shippingAddress))) {
            unset($this->ShippingAddress);
        } else {
            $this->ShippingAddress = $shippingAddress;
        }
        return $this;
    }
    /**
     * Get ShippingAddressSameAsMain value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShippingAddressSameAsMain()
    {
        return isset($this->ShippingAddressSameAsMain) ? $this->ShippingAddressSameAsMain : null;
    }
    /**
     * Set ShippingAddressSameAsMain value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setShippingAddressSameAsMain(\AcumaticaConfig\StructType\BooleanValue $shippingAddressSameAsMain = null)
    {
        if (is_null($shippingAddressSameAsMain) || (is_array($shippingAddressSameAsMain) && empty($shippingAddressSameAsMain))) {
            unset($this->ShippingAddressSameAsMain);
        } else {
            $this->ShippingAddressSameAsMain = $shippingAddressSameAsMain;
        }
        return $this;
    }
    /**
     * Get ShippingAddressValidated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getShippingAddressValidated()
    {
        return isset($this->ShippingAddressValidated) ? $this->ShippingAddressValidated : null;
    }
    /**
     * Set ShippingAddressValidated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $shippingAddressValidated
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setShippingAddressValidated(\AcumaticaConfig\StructType\BooleanValue $shippingAddressValidated = null)
    {
        if (is_null($shippingAddressValidated) || (is_array($shippingAddressValidated) && empty($shippingAddressValidated))) {
            unset($this->ShippingAddressValidated);
        } else {
            $this->ShippingAddressValidated = $shippingAddressValidated;
        }
        return $this;
    }
    /**
     * Get ShippingContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountShippingContact|null
     */
    public function getShippingContact()
    {
        return isset($this->ShippingContact) ? $this->ShippingContact : null;
    }
    /**
     * Set ShippingContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BusinessAccountShippingContact $shippingContact
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setShippingContact(\AcumaticaConfig\StructType\BusinessAccountShippingContact $shippingContact = null)
    {
        if (is_null($shippingContact) || (is_array($shippingContact) && empty($shippingContact))) {
            unset($this->ShippingContact);
        } else {
            $this->ShippingContact = $shippingContact;
        }
        return $this;
    }
    /**
     * Get SourceCampaign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSourceCampaign()
    {
        return isset($this->SourceCampaign) ? $this->SourceCampaign : null;
    }
    /**
     * Set SourceCampaign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $sourceCampaign
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setSourceCampaign(\AcumaticaConfig\StructType\StringValue $sourceCampaign = null)
    {
        if (is_null($sourceCampaign) || (is_array($sourceCampaign) && empty($sourceCampaign))) {
            unset($this->SourceCampaign);
        } else {
            $this->SourceCampaign = $sourceCampaign;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setType(\AcumaticaConfig\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get Workgroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWorkgroup()
    {
        return isset($this->Workgroup) ? $this->Workgroup : null;
    }
    /**
     * Set Workgroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $workgroup
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setWorkgroup(\AcumaticaConfig\StructType\StringValue $workgroup = null)
    {
        if (is_null($workgroup) || (is_array($workgroup) && empty($workgroup))) {
            unset($this->Workgroup);
        } else {
            $this->Workgroup = $workgroup;
        }
        return $this;
    }
    /**
     * Get WorkgroupDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getWorkgroupDescription()
    {
        return isset($this->WorkgroupDescription) ? $this->WorkgroupDescription : null;
    }
    /**
     * Set WorkgroupDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $workgroupDescription
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public function setWorkgroupDescription(\AcumaticaConfig\StructType\StringValue $workgroupDescription = null)
    {
        if (is_null($workgroupDescription) || (is_array($workgroupDescription) && empty($workgroupDescription))) {
            unset($this->WorkgroupDescription);
        } else {
            $this->WorkgroupDescription = $workgroupDescription;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\BusinessAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
