<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillToSettings StructType
 * @subpackage Structs
 */
class BillToSettings extends Entity
{
    /**
     * The BillToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Address
     */
    public $BillToAddress;
    /**
     * The BillToAddressOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BillToAddressOverride;
    /**
     * The BillToContact
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DocContact
     */
    public $BillToContact;
    /**
     * The BillToContactOverride
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $BillToContactOverride;
    /**
     * Constructor method for BillToSettings
     * @uses BillToSettings::setBillToAddress()
     * @uses BillToSettings::setBillToAddressOverride()
     * @uses BillToSettings::setBillToContact()
     * @uses BillToSettings::setBillToContactOverride()
     * @param \AcumaticaConfig\StructType\Address $billToAddress
     * @param \AcumaticaConfig\StructType\BooleanValue $billToAddressOverride
     * @param \AcumaticaConfig\StructType\DocContact $billToContact
     * @param \AcumaticaConfig\StructType\BooleanValue $billToContactOverride
     */
    public function __construct(\AcumaticaConfig\StructType\Address $billToAddress = null, \AcumaticaConfig\StructType\BooleanValue $billToAddressOverride = null, \AcumaticaConfig\StructType\DocContact $billToContact = null, \AcumaticaConfig\StructType\BooleanValue $billToContactOverride = null)
    {
        $this
            ->setBillToAddress($billToAddress)
            ->setBillToAddressOverride($billToAddressOverride)
            ->setBillToContact($billToContact)
            ->setBillToContactOverride($billToContactOverride);
    }
    /**
     * Get BillToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Address|null
     */
    public function getBillToAddress()
    {
        return isset($this->BillToAddress) ? $this->BillToAddress : null;
    }
    /**
     * Set BillToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Address $billToAddress
     * @return \AcumaticaConfig\StructType\BillToSettings
     */
    public function setBillToAddress(\AcumaticaConfig\StructType\Address $billToAddress = null)
    {
        if (is_null($billToAddress) || (is_array($billToAddress) && empty($billToAddress))) {
            unset($this->BillToAddress);
        } else {
            $this->BillToAddress = $billToAddress;
        }
        return $this;
    }
    /**
     * Get BillToAddressOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillToAddressOverride()
    {
        return isset($this->BillToAddressOverride) ? $this->BillToAddressOverride : null;
    }
    /**
     * Set BillToAddressOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billToAddressOverride
     * @return \AcumaticaConfig\StructType\BillToSettings
     */
    public function setBillToAddressOverride(\AcumaticaConfig\StructType\BooleanValue $billToAddressOverride = null)
    {
        if (is_null($billToAddressOverride) || (is_array($billToAddressOverride) && empty($billToAddressOverride))) {
            unset($this->BillToAddressOverride);
        } else {
            $this->BillToAddressOverride = $billToAddressOverride;
        }
        return $this;
    }
    /**
     * Get BillToContact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DocContact|null
     */
    public function getBillToContact()
    {
        return isset($this->BillToContact) ? $this->BillToContact : null;
    }
    /**
     * Set BillToContact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DocContact $billToContact
     * @return \AcumaticaConfig\StructType\BillToSettings
     */
    public function setBillToContact(\AcumaticaConfig\StructType\DocContact $billToContact = null)
    {
        if (is_null($billToContact) || (is_array($billToContact) && empty($billToContact))) {
            unset($this->BillToContact);
        } else {
            $this->BillToContact = $billToContact;
        }
        return $this;
    }
    /**
     * Get BillToContactOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getBillToContactOverride()
    {
        return isset($this->BillToContactOverride) ? $this->BillToContactOverride : null;
    }
    /**
     * Set BillToContactOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $billToContactOverride
     * @return \AcumaticaConfig\StructType\BillToSettings
     */
    public function setBillToContactOverride(\AcumaticaConfig\StructType\BooleanValue $billToContactOverride = null)
    {
        if (is_null($billToContactOverride) || (is_array($billToContactOverride) && empty($billToContactOverride))) {
            unset($this->BillToContactOverride);
        } else {
            $this->BillToContactOverride = $billToContactOverride;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\BillToSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
