<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillTaxDetail StructType
 * @subpackage Structs
 */
class BillTaxDetail extends Entity
{
    /**
     * The TaxableAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TaxableAmount;
    /**
     * The TaxAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TaxAmount;
    /**
     * The TaxID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $TaxID;
    /**
     * The TaxRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TaxRate;
    /**
     * Constructor method for BillTaxDetail
     * @uses BillTaxDetail::setTaxableAmount()
     * @uses BillTaxDetail::setTaxAmount()
     * @uses BillTaxDetail::setTaxID()
     * @uses BillTaxDetail::setTaxRate()
     * @param \AcumaticaConfig\StructType\DecimalValue $taxableAmount
     * @param \AcumaticaConfig\StructType\DecimalValue $taxAmount
     * @param \AcumaticaConfig\StructType\StringValue $taxID
     * @param \AcumaticaConfig\StructType\DecimalValue $taxRate
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $taxableAmount = null, \AcumaticaConfig\StructType\DecimalValue $taxAmount = null, \AcumaticaConfig\StructType\StringValue $taxID = null, \AcumaticaConfig\StructType\DecimalValue $taxRate = null)
    {
        $this
            ->setTaxableAmount($taxableAmount)
            ->setTaxAmount($taxAmount)
            ->setTaxID($taxID)
            ->setTaxRate($taxRate);
    }
    /**
     * Get TaxableAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTaxableAmount()
    {
        return isset($this->TaxableAmount) ? $this->TaxableAmount : null;
    }
    /**
     * Set TaxableAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $taxableAmount
     * @return \AcumaticaConfig\StructType\BillTaxDetail
     */
    public function setTaxableAmount(\AcumaticaConfig\StructType\DecimalValue $taxableAmount = null)
    {
        if (is_null($taxableAmount) || (is_array($taxableAmount) && empty($taxableAmount))) {
            unset($this->TaxableAmount);
        } else {
            $this->TaxableAmount = $taxableAmount;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $taxAmount
     * @return \AcumaticaConfig\StructType\BillTaxDetail
     */
    public function setTaxAmount(\AcumaticaConfig\StructType\DecimalValue $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TaxID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getTaxID()
    {
        return isset($this->TaxID) ? $this->TaxID : null;
    }
    /**
     * Set TaxID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $taxID
     * @return \AcumaticaConfig\StructType\BillTaxDetail
     */
    public function setTaxID(\AcumaticaConfig\StructType\StringValue $taxID = null)
    {
        if (is_null($taxID) || (is_array($taxID) && empty($taxID))) {
            unset($this->TaxID);
        } else {
            $this->TaxID = $taxID;
        }
        return $this;
    }
    /**
     * Get TaxRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTaxRate()
    {
        return isset($this->TaxRate) ? $this->TaxRate : null;
    }
    /**
     * Set TaxRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $taxRate
     * @return \AcumaticaConfig\StructType\BillTaxDetail
     */
    public function setTaxRate(\AcumaticaConfig\StructType\DecimalValue $taxRate = null)
    {
        if (is_null($taxRate) || (is_array($taxRate) && empty($taxRate))) {
            unset($this->TaxRate);
        } else {
            $this->TaxRate = $taxRate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\BillTaxDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
