<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillApplicationDetail StructType
 * @subpackage Structs
 */
class BillApplicationDetail extends Entity
{
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $AmountPaid;
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Balance;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $DocType;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * Constructor method for BillApplicationDetail
     * @uses BillApplicationDetail::setAmountPaid()
     * @uses BillApplicationDetail::setBalance()
     * @uses BillApplicationDetail::setDocType()
     * @uses BillApplicationDetail::setReferenceNbr()
     * @uses BillApplicationDetail::setStatus()
     * @param \AcumaticaConfig\StructType\DecimalValue $amountPaid
     * @param \AcumaticaConfig\StructType\DecimalValue $balance
     * @param \AcumaticaConfig\StructType\StringValue $docType
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @param \AcumaticaConfig\StructType\StringValue $status
     */
    public function __construct(\AcumaticaConfig\StructType\DecimalValue $amountPaid = null, \AcumaticaConfig\StructType\DecimalValue $balance = null, \AcumaticaConfig\StructType\StringValue $docType = null, \AcumaticaConfig\StructType\StringValue $referenceNbr = null, \AcumaticaConfig\StructType\StringValue $status = null)
    {
        $this
            ->setAmountPaid($amountPaid)
            ->setBalance($balance)
            ->setDocType($docType)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status);
    }
    /**
     * Get AmountPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getAmountPaid()
    {
        return isset($this->AmountPaid) ? $this->AmountPaid : null;
    }
    /**
     * Set AmountPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $amountPaid
     * @return \AcumaticaConfig\StructType\BillApplicationDetail
     */
    public function setAmountPaid(\AcumaticaConfig\StructType\DecimalValue $amountPaid = null)
    {
        if (is_null($amountPaid) || (is_array($amountPaid) && empty($amountPaid))) {
            unset($this->AmountPaid);
        } else {
            $this->AmountPaid = $amountPaid;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $balance
     * @return \AcumaticaConfig\StructType\BillApplicationDetail
     */
    public function setBalance(\AcumaticaConfig\StructType\DecimalValue $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get DocType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDocType()
    {
        return isset($this->DocType) ? $this->DocType : null;
    }
    /**
     * Set DocType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $docType
     * @return \AcumaticaConfig\StructType\BillApplicationDetail
     */
    public function setDocType(\AcumaticaConfig\StructType\StringValue $docType = null)
    {
        if (is_null($docType) || (is_array($docType) && empty($docType))) {
            unset($this->DocType);
        } else {
            $this->DocType = $docType;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @return \AcumaticaConfig\StructType\BillApplicationDetail
     */
    public function setReferenceNbr(\AcumaticaConfig\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\BillApplicationDetail
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\BillApplicationDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
