<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applications StructType
 * @subpackage Structs
 */
class Applications extends AbstractStructBase
{
    /**
     * The BillApplicationDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BillApplicationDetail[]
     */
    public $BillApplicationDetail;
    /**
     * Constructor method for Applications
     * @uses Applications::setBillApplicationDetail()
     * @param \AcumaticaConfig\StructType\BillApplicationDetail[] $billApplicationDetail
     */
    public function __construct(array $billApplicationDetail = array())
    {
        $this
            ->setBillApplicationDetail($billApplicationDetail);
    }
    /**
     * Get BillApplicationDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BillApplicationDetail[]|null
     */
    public function getBillApplicationDetail()
    {
        return isset($this->BillApplicationDetail) ? $this->BillApplicationDetail : null;
    }
    /**
     * Set BillApplicationDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BillApplicationDetail[] $billApplicationDetail
     * @return \AcumaticaConfig\StructType\Applications
     */
    public function setBillApplicationDetail(array $billApplicationDetail = array())
    {
        foreach ($billApplicationDetail as $applicationsBillApplicationDetailItem) {
            // validation for constraint: itemType
            if (!$applicationsBillApplicationDetailItem instanceof \AcumaticaConfig\StructType\BillApplicationDetail) {
                throw new \InvalidArgumentException(sprintf('The BillApplicationDetail property can only contain items of \AcumaticaConfig\StructType\BillApplicationDetail, "%s" given', is_object($applicationsBillApplicationDetailItem) ? get_class($applicationsBillApplicationDetailItem) : gettype($applicationsBillApplicationDetailItem)), __LINE__);
            }
        }
        if (is_null($billApplicationDetail) || (is_array($billApplicationDetail) && empty($billApplicationDetail))) {
            unset($this->BillApplicationDetail);
        } else {
            $this->BillApplicationDetail = $billApplicationDetail;
        }
        return $this;
    }
    /**
     * Add item to BillApplicationDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BillApplicationDetail $item
     * @return \AcumaticaConfig\StructType\Applications
     */
    public function addToBillApplicationDetail(\AcumaticaConfig\StructType\BillApplicationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BillApplicationDetail) {
            throw new \InvalidArgumentException(sprintf('The BillApplicationDetail property can only contain items of \AcumaticaConfig\StructType\BillApplicationDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillApplicationDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Applications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
