<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationHistory StructType
 * @subpackage Structs
 */
class ApplicationHistory extends AbstractStructBase
{
    /**
     * The PaymentApplicationHistoryDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail[]
     */
    public $PaymentApplicationHistoryDetail;
    /**
     * Constructor method for ApplicationHistory
     * @uses ApplicationHistory::setPaymentApplicationHistoryDetail()
     * @param \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail[] $paymentApplicationHistoryDetail
     */
    public function __construct(array $paymentApplicationHistoryDetail = array())
    {
        $this
            ->setPaymentApplicationHistoryDetail($paymentApplicationHistoryDetail);
    }
    /**
     * Get PaymentApplicationHistoryDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail[]|null
     */
    public function getPaymentApplicationHistoryDetail()
    {
        return isset($this->PaymentApplicationHistoryDetail) ? $this->PaymentApplicationHistoryDetail : null;
    }
    /**
     * Set PaymentApplicationHistoryDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail[] $paymentApplicationHistoryDetail
     * @return \AcumaticaConfig\StructType\ApplicationHistory
     */
    public function setPaymentApplicationHistoryDetail(array $paymentApplicationHistoryDetail = array())
    {
        foreach ($paymentApplicationHistoryDetail as $applicationHistoryPaymentApplicationHistoryDetailItem) {
            // validation for constraint: itemType
            if (!$applicationHistoryPaymentApplicationHistoryDetailItem instanceof \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail) {
                throw new \InvalidArgumentException(sprintf('The PaymentApplicationHistoryDetail property can only contain items of \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail, "%s" given', is_object($applicationHistoryPaymentApplicationHistoryDetailItem) ? get_class($applicationHistoryPaymentApplicationHistoryDetailItem) : gettype($applicationHistoryPaymentApplicationHistoryDetailItem)), __LINE__);
            }
        }
        if (is_null($paymentApplicationHistoryDetail) || (is_array($paymentApplicationHistoryDetail) && empty($paymentApplicationHistoryDetail))) {
            unset($this->PaymentApplicationHistoryDetail);
        } else {
            $this->PaymentApplicationHistoryDetail = $paymentApplicationHistoryDetail;
        }
        return $this;
    }
    /**
     * Add item to PaymentApplicationHistoryDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail $item
     * @return \AcumaticaConfig\StructType\ApplicationHistory
     */
    public function addToPaymentApplicationHistoryDetail(\AcumaticaConfig\StructType\PaymentApplicationHistoryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail) {
            throw new \InvalidArgumentException(sprintf('The PaymentApplicationHistoryDetail property can only contain items of \AcumaticaConfig\StructType\PaymentApplicationHistoryDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentApplicationHistoryDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\ApplicationHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
