<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Allocations StructType
 * @subpackage Structs
 */
class Allocations extends AbstractStructBase
{
    /**
     * The PurchaseReceiptDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation[]
     */
    public $PurchaseReceiptDetailAllocation;
    /**
     * The SalesOrderDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\SalesOrderDetailAllocation[]
     */
    public $SalesOrderDetailAllocation;
    /**
     * The KitAssemblyStockComponentAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation[]
     */
    public $KitAssemblyStockComponentAllocation;
    /**
     * The ShipmentDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ShipmentDetailAllocation[]
     */
    public $ShipmentDetailAllocation;
    /**
     * The TransferOrderDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\TransferOrderDetailAllocation[]
     */
    public $TransferOrderDetailAllocation;
    /**
     * The KitAssemblyAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\KitAssemblyAllocation[]
     */
    public $KitAssemblyAllocation;
    /**
     * The InventoryReceiptDetailAllocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation[]
     */
    public $InventoryReceiptDetailAllocation;
    /**
     * Constructor method for Allocations
     * @uses Allocations::setPurchaseReceiptDetailAllocation()
     * @uses Allocations::setSalesOrderDetailAllocation()
     * @uses Allocations::setKitAssemblyStockComponentAllocation()
     * @uses Allocations::setShipmentDetailAllocation()
     * @uses Allocations::setTransferOrderDetailAllocation()
     * @uses Allocations::setKitAssemblyAllocation()
     * @uses Allocations::setInventoryReceiptDetailAllocation()
     * @param \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation[] $purchaseReceiptDetailAllocation
     * @param \AcumaticaConfig\StructType\SalesOrderDetailAllocation[] $salesOrderDetailAllocation
     * @param \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation[] $kitAssemblyStockComponentAllocation
     * @param \AcumaticaConfig\StructType\ShipmentDetailAllocation[] $shipmentDetailAllocation
     * @param \AcumaticaConfig\StructType\TransferOrderDetailAllocation[] $transferOrderDetailAllocation
     * @param \AcumaticaConfig\StructType\KitAssemblyAllocation[] $kitAssemblyAllocation
     * @param \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation[] $inventoryReceiptDetailAllocation
     */
    public function __construct(array $purchaseReceiptDetailAllocation = array(), array $salesOrderDetailAllocation = array(), array $kitAssemblyStockComponentAllocation = array(), array $shipmentDetailAllocation = array(), array $transferOrderDetailAllocation = array(), array $kitAssemblyAllocation = array(), array $inventoryReceiptDetailAllocation = array())
    {
        $this
            ->setPurchaseReceiptDetailAllocation($purchaseReceiptDetailAllocation)
            ->setSalesOrderDetailAllocation($salesOrderDetailAllocation)
            ->setKitAssemblyStockComponentAllocation($kitAssemblyStockComponentAllocation)
            ->setShipmentDetailAllocation($shipmentDetailAllocation)
            ->setTransferOrderDetailAllocation($transferOrderDetailAllocation)
            ->setKitAssemblyAllocation($kitAssemblyAllocation)
            ->setInventoryReceiptDetailAllocation($inventoryReceiptDetailAllocation);
    }
    /**
     * Get PurchaseReceiptDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation[]|null
     */
    public function getPurchaseReceiptDetailAllocation()
    {
        return isset($this->PurchaseReceiptDetailAllocation) ? $this->PurchaseReceiptDetailAllocation : null;
    }
    /**
     * Set PurchaseReceiptDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation[] $purchaseReceiptDetailAllocation
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function setPurchaseReceiptDetailAllocation(array $purchaseReceiptDetailAllocation = array())
    {
        foreach ($purchaseReceiptDetailAllocation as $allocationsPurchaseReceiptDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsPurchaseReceiptDetailAllocationItem instanceof \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetailAllocation property can only contain items of \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation, "%s" given', is_object($allocationsPurchaseReceiptDetailAllocationItem) ? get_class($allocationsPurchaseReceiptDetailAllocationItem) : gettype($allocationsPurchaseReceiptDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($purchaseReceiptDetailAllocation) || (is_array($purchaseReceiptDetailAllocation) && empty($purchaseReceiptDetailAllocation))) {
            unset($this->PurchaseReceiptDetailAllocation);
        } else {
            $this->PurchaseReceiptDetailAllocation = $purchaseReceiptDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to PurchaseReceiptDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation $item
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function addToPurchaseReceiptDetailAllocation(\AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The PurchaseReceiptDetailAllocation property can only contain items of \AcumaticaConfig\StructType\PurchaseReceiptDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PurchaseReceiptDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get SalesOrderDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\SalesOrderDetailAllocation[]|null
     */
    public function getSalesOrderDetailAllocation()
    {
        return isset($this->SalesOrderDetailAllocation) ? $this->SalesOrderDetailAllocation : null;
    }
    /**
     * Set SalesOrderDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrderDetailAllocation[] $salesOrderDetailAllocation
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function setSalesOrderDetailAllocation(array $salesOrderDetailAllocation = array())
    {
        foreach ($salesOrderDetailAllocation as $allocationsSalesOrderDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsSalesOrderDetailAllocationItem instanceof \AcumaticaConfig\StructType\SalesOrderDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The SalesOrderDetailAllocation property can only contain items of \AcumaticaConfig\StructType\SalesOrderDetailAllocation, "%s" given', is_object($allocationsSalesOrderDetailAllocationItem) ? get_class($allocationsSalesOrderDetailAllocationItem) : gettype($allocationsSalesOrderDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($salesOrderDetailAllocation) || (is_array($salesOrderDetailAllocation) && empty($salesOrderDetailAllocation))) {
            unset($this->SalesOrderDetailAllocation);
        } else {
            $this->SalesOrderDetailAllocation = $salesOrderDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to SalesOrderDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\SalesOrderDetailAllocation $item
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function addToSalesOrderDetailAllocation(\AcumaticaConfig\StructType\SalesOrderDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\SalesOrderDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The SalesOrderDetailAllocation property can only contain items of \AcumaticaConfig\StructType\SalesOrderDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SalesOrderDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyStockComponentAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation[]|null
     */
    public function getKitAssemblyStockComponentAllocation()
    {
        return isset($this->KitAssemblyStockComponentAllocation) ? $this->KitAssemblyStockComponentAllocation : null;
    }
    /**
     * Set KitAssemblyStockComponentAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation[] $kitAssemblyStockComponentAllocation
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function setKitAssemblyStockComponentAllocation(array $kitAssemblyStockComponentAllocation = array())
    {
        foreach ($kitAssemblyStockComponentAllocation as $allocationsKitAssemblyStockComponentAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsKitAssemblyStockComponentAllocationItem instanceof \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation) {
                throw new \InvalidArgumentException(sprintf('The KitAssemblyStockComponentAllocation property can only contain items of \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation, "%s" given', is_object($allocationsKitAssemblyStockComponentAllocationItem) ? get_class($allocationsKitAssemblyStockComponentAllocationItem) : gettype($allocationsKitAssemblyStockComponentAllocationItem)), __LINE__);
            }
        }
        if (is_null($kitAssemblyStockComponentAllocation) || (is_array($kitAssemblyStockComponentAllocation) && empty($kitAssemblyStockComponentAllocation))) {
            unset($this->KitAssemblyStockComponentAllocation);
        } else {
            $this->KitAssemblyStockComponentAllocation = $kitAssemblyStockComponentAllocation;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyStockComponentAllocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation $item
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function addToKitAssemblyStockComponentAllocation(\AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyStockComponentAllocation property can only contain items of \AcumaticaConfig\StructType\KitAssemblyStockComponentAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitAssemblyStockComponentAllocation[] = $item;
        return $this;
    }
    /**
     * Get ShipmentDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ShipmentDetailAllocation[]|null
     */
    public function getShipmentDetailAllocation()
    {
        return isset($this->ShipmentDetailAllocation) ? $this->ShipmentDetailAllocation : null;
    }
    /**
     * Set ShipmentDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentDetailAllocation[] $shipmentDetailAllocation
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function setShipmentDetailAllocation(array $shipmentDetailAllocation = array())
    {
        foreach ($shipmentDetailAllocation as $allocationsShipmentDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsShipmentDetailAllocationItem instanceof \AcumaticaConfig\StructType\ShipmentDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The ShipmentDetailAllocation property can only contain items of \AcumaticaConfig\StructType\ShipmentDetailAllocation, "%s" given', is_object($allocationsShipmentDetailAllocationItem) ? get_class($allocationsShipmentDetailAllocationItem) : gettype($allocationsShipmentDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($shipmentDetailAllocation) || (is_array($shipmentDetailAllocation) && empty($shipmentDetailAllocation))) {
            unset($this->ShipmentDetailAllocation);
        } else {
            $this->ShipmentDetailAllocation = $shipmentDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to ShipmentDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ShipmentDetailAllocation $item
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function addToShipmentDetailAllocation(\AcumaticaConfig\StructType\ShipmentDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ShipmentDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The ShipmentDetailAllocation property can only contain items of \AcumaticaConfig\StructType\ShipmentDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ShipmentDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get TransferOrderDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\TransferOrderDetailAllocation[]|null
     */
    public function getTransferOrderDetailAllocation()
    {
        return isset($this->TransferOrderDetailAllocation) ? $this->TransferOrderDetailAllocation : null;
    }
    /**
     * Set TransferOrderDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TransferOrderDetailAllocation[] $transferOrderDetailAllocation
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function setTransferOrderDetailAllocation(array $transferOrderDetailAllocation = array())
    {
        foreach ($transferOrderDetailAllocation as $allocationsTransferOrderDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsTransferOrderDetailAllocationItem instanceof \AcumaticaConfig\StructType\TransferOrderDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The TransferOrderDetailAllocation property can only contain items of \AcumaticaConfig\StructType\TransferOrderDetailAllocation, "%s" given', is_object($allocationsTransferOrderDetailAllocationItem) ? get_class($allocationsTransferOrderDetailAllocationItem) : gettype($allocationsTransferOrderDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($transferOrderDetailAllocation) || (is_array($transferOrderDetailAllocation) && empty($transferOrderDetailAllocation))) {
            unset($this->TransferOrderDetailAllocation);
        } else {
            $this->TransferOrderDetailAllocation = $transferOrderDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to TransferOrderDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\TransferOrderDetailAllocation $item
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function addToTransferOrderDetailAllocation(\AcumaticaConfig\StructType\TransferOrderDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\TransferOrderDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The TransferOrderDetailAllocation property can only contain items of \AcumaticaConfig\StructType\TransferOrderDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferOrderDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Get KitAssemblyAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\KitAssemblyAllocation[]|null
     */
    public function getKitAssemblyAllocation()
    {
        return isset($this->KitAssemblyAllocation) ? $this->KitAssemblyAllocation : null;
    }
    /**
     * Set KitAssemblyAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitAssemblyAllocation[] $kitAssemblyAllocation
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function setKitAssemblyAllocation(array $kitAssemblyAllocation = array())
    {
        foreach ($kitAssemblyAllocation as $allocationsKitAssemblyAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsKitAssemblyAllocationItem instanceof \AcumaticaConfig\StructType\KitAssemblyAllocation) {
                throw new \InvalidArgumentException(sprintf('The KitAssemblyAllocation property can only contain items of \AcumaticaConfig\StructType\KitAssemblyAllocation, "%s" given', is_object($allocationsKitAssemblyAllocationItem) ? get_class($allocationsKitAssemblyAllocationItem) : gettype($allocationsKitAssemblyAllocationItem)), __LINE__);
            }
        }
        if (is_null($kitAssemblyAllocation) || (is_array($kitAssemblyAllocation) && empty($kitAssemblyAllocation))) {
            unset($this->KitAssemblyAllocation);
        } else {
            $this->KitAssemblyAllocation = $kitAssemblyAllocation;
        }
        return $this;
    }
    /**
     * Add item to KitAssemblyAllocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\KitAssemblyAllocation $item
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function addToKitAssemblyAllocation(\AcumaticaConfig\StructType\KitAssemblyAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\KitAssemblyAllocation) {
            throw new \InvalidArgumentException(sprintf('The KitAssemblyAllocation property can only contain items of \AcumaticaConfig\StructType\KitAssemblyAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->KitAssemblyAllocation[] = $item;
        return $this;
    }
    /**
     * Get InventoryReceiptDetailAllocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation[]|null
     */
    public function getInventoryReceiptDetailAllocation()
    {
        return isset($this->InventoryReceiptDetailAllocation) ? $this->InventoryReceiptDetailAllocation : null;
    }
    /**
     * Set InventoryReceiptDetailAllocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation[] $inventoryReceiptDetailAllocation
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function setInventoryReceiptDetailAllocation(array $inventoryReceiptDetailAllocation = array())
    {
        foreach ($inventoryReceiptDetailAllocation as $allocationsInventoryReceiptDetailAllocationItem) {
            // validation for constraint: itemType
            if (!$allocationsInventoryReceiptDetailAllocationItem instanceof \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation) {
                throw new \InvalidArgumentException(sprintf('The InventoryReceiptDetailAllocation property can only contain items of \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation, "%s" given', is_object($allocationsInventoryReceiptDetailAllocationItem) ? get_class($allocationsInventoryReceiptDetailAllocationItem) : gettype($allocationsInventoryReceiptDetailAllocationItem)), __LINE__);
            }
        }
        if (is_null($inventoryReceiptDetailAllocation) || (is_array($inventoryReceiptDetailAllocation) && empty($inventoryReceiptDetailAllocation))) {
            unset($this->InventoryReceiptDetailAllocation);
        } else {
            $this->InventoryReceiptDetailAllocation = $inventoryReceiptDetailAllocation;
        }
        return $this;
    }
    /**
     * Add item to InventoryReceiptDetailAllocation value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation $item
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public function addToInventoryReceiptDetailAllocation(\AcumaticaConfig\StructType\InventoryReceiptDetailAllocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation) {
            throw new \InvalidArgumentException(sprintf('The InventoryReceiptDetailAllocation property can only contain items of \AcumaticaConfig\StructType\InventoryReceiptDetailAllocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryReceiptDetailAllocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Allocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
