<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adjustment StructType
 * @subpackage Structs
 */
class Adjustment extends Entity
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $Date;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Details
     */
    public $Details;
    /**
     * The ExternalRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ExternalRef;
    /**
     * The Hold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $Hold;
    /**
     * The ReferenceNbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ReferenceNbr;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Status;
    /**
     * The TotalCost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TotalCost;
    /**
     * The TotalQty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $TotalQty;
    /**
     * Constructor method for Adjustment
     * @uses Adjustment::setDate()
     * @uses Adjustment::setDescription()
     * @uses Adjustment::setDetails()
     * @uses Adjustment::setExternalRef()
     * @uses Adjustment::setHold()
     * @uses Adjustment::setReferenceNbr()
     * @uses Adjustment::setStatus()
     * @uses Adjustment::setTotalCost()
     * @uses Adjustment::setTotalQty()
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\Details $details
     * @param \AcumaticaConfig\StructType\StringValue $externalRef
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @param \AcumaticaConfig\StructType\DecimalValue $totalCost
     * @param \AcumaticaConfig\StructType\DecimalValue $totalQty
     */
    public function __construct(\AcumaticaConfig\StructType\DateTimeValue $date = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\Details $details = null, \AcumaticaConfig\StructType\StringValue $externalRef = null, \AcumaticaConfig\StructType\BooleanValue $hold = null, \AcumaticaConfig\StructType\StringValue $referenceNbr = null, \AcumaticaConfig\StructType\StringValue $status = null, \AcumaticaConfig\StructType\DecimalValue $totalCost = null, \AcumaticaConfig\StructType\DecimalValue $totalQty = null)
    {
        $this
            ->setDate($date)
            ->setDescription($description)
            ->setDetails($details)
            ->setExternalRef($externalRef)
            ->setHold($hold)
            ->setReferenceNbr($referenceNbr)
            ->setStatus($status)
            ->setTotalCost($totalCost)
            ->setTotalQty($totalQty);
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $date
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setDate(\AcumaticaConfig\StructType\DateTimeValue $date = null)
    {
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Details|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Details $details
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setDetails(\AcumaticaConfig\StructType\Details $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get ExternalRef value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getExternalRef()
    {
        return isset($this->ExternalRef) ? $this->ExternalRef : null;
    }
    /**
     * Set ExternalRef value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $externalRef
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setExternalRef(\AcumaticaConfig\StructType\StringValue $externalRef = null)
    {
        if (is_null($externalRef) || (is_array($externalRef) && empty($externalRef))) {
            unset($this->ExternalRef);
        } else {
            $this->ExternalRef = $externalRef;
        }
        return $this;
    }
    /**
     * Get Hold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getHold()
    {
        return isset($this->Hold) ? $this->Hold : null;
    }
    /**
     * Set Hold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $hold
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setHold(\AcumaticaConfig\StructType\BooleanValue $hold = null)
    {
        if (is_null($hold) || (is_array($hold) && empty($hold))) {
            unset($this->Hold);
        } else {
            $this->Hold = $hold;
        }
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getReferenceNbr()
    {
        return isset($this->ReferenceNbr) ? $this->ReferenceNbr : null;
    }
    /**
     * Set ReferenceNbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $referenceNbr
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setReferenceNbr(\AcumaticaConfig\StructType\StringValue $referenceNbr = null)
    {
        if (is_null($referenceNbr) || (is_array($referenceNbr) && empty($referenceNbr))) {
            unset($this->ReferenceNbr);
        } else {
            $this->ReferenceNbr = $referenceNbr;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $status
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setStatus(\AcumaticaConfig\StructType\StringValue $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTotalCost()
    {
        return isset($this->TotalCost) ? $this->TotalCost : null;
    }
    /**
     * Set TotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $totalCost
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setTotalCost(\AcumaticaConfig\StructType\DecimalValue $totalCost = null)
    {
        if (is_null($totalCost) || (is_array($totalCost) && empty($totalCost))) {
            unset($this->TotalCost);
        } else {
            $this->TotalCost = $totalCost;
        }
        return $this;
    }
    /**
     * Get TotalQty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTotalQty()
    {
        return isset($this->TotalQty) ? $this->TotalQty : null;
    }
    /**
     * Set TotalQty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $totalQty
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public function setTotalQty(\AcumaticaConfig\StructType\DecimalValue $totalQty = null)
    {
        if (is_null($totalQty) || (is_array($totalQty) && empty($totalQty))) {
            unset($this->TotalQty);
        } else {
            $this->TotalQty = $totalQty;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Adjustment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
