<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activities StructType
 * @subpackage Structs
 */
class Activities extends AbstractStructBase
{
    /**
     * The ActivityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\ActivityDetail[]
     */
    public $ActivityDetail;
    /**
     * The BusinessAccountActivityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BusinessAccountActivityDetail[]
     */
    public $BusinessAccountActivityDetail;
    /**
     * The CaseActivityDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\CaseActivityDetail[]
     */
    public $CaseActivityDetail;
    /**
     * Constructor method for Activities
     * @uses Activities::setActivityDetail()
     * @uses Activities::setBusinessAccountActivityDetail()
     * @uses Activities::setCaseActivityDetail()
     * @param \AcumaticaConfig\StructType\ActivityDetail[] $activityDetail
     * @param \AcumaticaConfig\StructType\BusinessAccountActivityDetail[] $businessAccountActivityDetail
     * @param \AcumaticaConfig\StructType\CaseActivityDetail[] $caseActivityDetail
     */
    public function __construct(array $activityDetail = array(), array $businessAccountActivityDetail = array(), array $caseActivityDetail = array())
    {
        $this
            ->setActivityDetail($activityDetail)
            ->setBusinessAccountActivityDetail($businessAccountActivityDetail)
            ->setCaseActivityDetail($caseActivityDetail);
    }
    /**
     * Get ActivityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\ActivityDetail[]|null
     */
    public function getActivityDetail()
    {
        return isset($this->ActivityDetail) ? $this->ActivityDetail : null;
    }
    /**
     * Set ActivityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ActivityDetail[] $activityDetail
     * @return \AcumaticaConfig\StructType\Activities
     */
    public function setActivityDetail(array $activityDetail = array())
    {
        foreach ($activityDetail as $activitiesActivityDetailItem) {
            // validation for constraint: itemType
            if (!$activitiesActivityDetailItem instanceof \AcumaticaConfig\StructType\ActivityDetail) {
                throw new \InvalidArgumentException(sprintf('The ActivityDetail property can only contain items of \AcumaticaConfig\StructType\ActivityDetail, "%s" given', is_object($activitiesActivityDetailItem) ? get_class($activitiesActivityDetailItem) : gettype($activitiesActivityDetailItem)), __LINE__);
            }
        }
        if (is_null($activityDetail) || (is_array($activityDetail) && empty($activityDetail))) {
            unset($this->ActivityDetail);
        } else {
            $this->ActivityDetail = $activityDetail;
        }
        return $this;
    }
    /**
     * Add item to ActivityDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\ActivityDetail $item
     * @return \AcumaticaConfig\StructType\Activities
     */
    public function addToActivityDetail(\AcumaticaConfig\StructType\ActivityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\ActivityDetail) {
            throw new \InvalidArgumentException(sprintf('The ActivityDetail property can only contain items of \AcumaticaConfig\StructType\ActivityDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActivityDetail[] = $item;
        return $this;
    }
    /**
     * Get BusinessAccountActivityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BusinessAccountActivityDetail[]|null
     */
    public function getBusinessAccountActivityDetail()
    {
        return isset($this->BusinessAccountActivityDetail) ? $this->BusinessAccountActivityDetail : null;
    }
    /**
     * Set BusinessAccountActivityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountActivityDetail[] $businessAccountActivityDetail
     * @return \AcumaticaConfig\StructType\Activities
     */
    public function setBusinessAccountActivityDetail(array $businessAccountActivityDetail = array())
    {
        foreach ($businessAccountActivityDetail as $activitiesBusinessAccountActivityDetailItem) {
            // validation for constraint: itemType
            if (!$activitiesBusinessAccountActivityDetailItem instanceof \AcumaticaConfig\StructType\BusinessAccountActivityDetail) {
                throw new \InvalidArgumentException(sprintf('The BusinessAccountActivityDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountActivityDetail, "%s" given', is_object($activitiesBusinessAccountActivityDetailItem) ? get_class($activitiesBusinessAccountActivityDetailItem) : gettype($activitiesBusinessAccountActivityDetailItem)), __LINE__);
            }
        }
        if (is_null($businessAccountActivityDetail) || (is_array($businessAccountActivityDetail) && empty($businessAccountActivityDetail))) {
            unset($this->BusinessAccountActivityDetail);
        } else {
            $this->BusinessAccountActivityDetail = $businessAccountActivityDetail;
        }
        return $this;
    }
    /**
     * Add item to BusinessAccountActivityDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\BusinessAccountActivityDetail $item
     * @return \AcumaticaConfig\StructType\Activities
     */
    public function addToBusinessAccountActivityDetail(\AcumaticaConfig\StructType\BusinessAccountActivityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\BusinessAccountActivityDetail) {
            throw new \InvalidArgumentException(sprintf('The BusinessAccountActivityDetail property can only contain items of \AcumaticaConfig\StructType\BusinessAccountActivityDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessAccountActivityDetail[] = $item;
        return $this;
    }
    /**
     * Get CaseActivityDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\CaseActivityDetail[]|null
     */
    public function getCaseActivityDetail()
    {
        return isset($this->CaseActivityDetail) ? $this->CaseActivityDetail : null;
    }
    /**
     * Set CaseActivityDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CaseActivityDetail[] $caseActivityDetail
     * @return \AcumaticaConfig\StructType\Activities
     */
    public function setCaseActivityDetail(array $caseActivityDetail = array())
    {
        foreach ($caseActivityDetail as $activitiesCaseActivityDetailItem) {
            // validation for constraint: itemType
            if (!$activitiesCaseActivityDetailItem instanceof \AcumaticaConfig\StructType\CaseActivityDetail) {
                throw new \InvalidArgumentException(sprintf('The CaseActivityDetail property can only contain items of \AcumaticaConfig\StructType\CaseActivityDetail, "%s" given', is_object($activitiesCaseActivityDetailItem) ? get_class($activitiesCaseActivityDetailItem) : gettype($activitiesCaseActivityDetailItem)), __LINE__);
            }
        }
        if (is_null($caseActivityDetail) || (is_array($caseActivityDetail) && empty($caseActivityDetail))) {
            unset($this->CaseActivityDetail);
        } else {
            $this->CaseActivityDetail = $caseActivityDetail;
        }
        return $this;
    }
    /**
     * Add item to CaseActivityDetail value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\CaseActivityDetail $item
     * @return \AcumaticaConfig\StructType\Activities
     */
    public function addToCaseActivityDetail(\AcumaticaConfig\StructType\CaseActivityDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\CaseActivityDetail) {
            throw new \InvalidArgumentException(sprintf('The CaseActivityDetail property can only contain items of \AcumaticaConfig\StructType\CaseActivityDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CaseActivityDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\Activities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
