<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountSummaryRow StructType
 * @subpackage Structs
 */
class AccountSummaryRow extends Entity
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Account;
    /**
     * The AccountClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $AccountClass;
    /**
     * The BeginingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $BeginingBalance;
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Branch;
    /**
     * The ConsolidationAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ConsolidationAccount;
    /**
     * The CreditTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CreditTotal;
    /**
     * The CurrencyBeginingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrencyBeginingBalance;
    /**
     * The CurrencyCreditTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrencyCreditTotal;
    /**
     * The CurrencyDebitTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrencyDebitTotal;
    /**
     * The CurrencyEndingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrencyEndingBalance;
    /**
     * The CurrencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $CurrencyID;
    /**
     * The CurrencyPtdTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $CurrencyPtdTotal;
    /**
     * The DebitTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $DebitTotal;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Description;
    /**
     * The EndingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $EndingBalance;
    /**
     * The LastActivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $LastActivity;
    /**
     * The LedgerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\IntValue
     */
    public $LedgerID;
    /**
     * The PtdTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $PtdTotal;
    /**
     * The Subaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Subaccount;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Type;
    /**
     * Constructor method for AccountSummaryRow
     * @uses AccountSummaryRow::setAccount()
     * @uses AccountSummaryRow::setAccountClass()
     * @uses AccountSummaryRow::setBeginingBalance()
     * @uses AccountSummaryRow::setBranch()
     * @uses AccountSummaryRow::setConsolidationAccount()
     * @uses AccountSummaryRow::setCreditTotal()
     * @uses AccountSummaryRow::setCurrencyBeginingBalance()
     * @uses AccountSummaryRow::setCurrencyCreditTotal()
     * @uses AccountSummaryRow::setCurrencyDebitTotal()
     * @uses AccountSummaryRow::setCurrencyEndingBalance()
     * @uses AccountSummaryRow::setCurrencyID()
     * @uses AccountSummaryRow::setCurrencyPtdTotal()
     * @uses AccountSummaryRow::setDebitTotal()
     * @uses AccountSummaryRow::setDescription()
     * @uses AccountSummaryRow::setEndingBalance()
     * @uses AccountSummaryRow::setLastActivity()
     * @uses AccountSummaryRow::setLedgerID()
     * @uses AccountSummaryRow::setPtdTotal()
     * @uses AccountSummaryRow::setSubaccount()
     * @uses AccountSummaryRow::setType()
     * @param \AcumaticaConfig\StructType\StringValue $account
     * @param \AcumaticaConfig\StructType\StringValue $accountClass
     * @param \AcumaticaConfig\StructType\DecimalValue $beginingBalance
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @param \AcumaticaConfig\StructType\StringValue $consolidationAccount
     * @param \AcumaticaConfig\StructType\DecimalValue $creditTotal
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyBeginingBalance
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyCreditTotal
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyDebitTotal
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyEndingBalance
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyPtdTotal
     * @param \AcumaticaConfig\StructType\DecimalValue $debitTotal
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @param \AcumaticaConfig\StructType\DecimalValue $endingBalance
     * @param \AcumaticaConfig\StructType\StringValue $lastActivity
     * @param \AcumaticaConfig\StructType\IntValue $ledgerID
     * @param \AcumaticaConfig\StructType\DecimalValue $ptdTotal
     * @param \AcumaticaConfig\StructType\StringValue $subaccount
     * @param \AcumaticaConfig\StructType\StringValue $type
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $account = null, \AcumaticaConfig\StructType\StringValue $accountClass = null, \AcumaticaConfig\StructType\DecimalValue $beginingBalance = null, \AcumaticaConfig\StructType\StringValue $branch = null, \AcumaticaConfig\StructType\StringValue $consolidationAccount = null, \AcumaticaConfig\StructType\DecimalValue $creditTotal = null, \AcumaticaConfig\StructType\DecimalValue $currencyBeginingBalance = null, \AcumaticaConfig\StructType\DecimalValue $currencyCreditTotal = null, \AcumaticaConfig\StructType\DecimalValue $currencyDebitTotal = null, \AcumaticaConfig\StructType\DecimalValue $currencyEndingBalance = null, \AcumaticaConfig\StructType\StringValue $currencyID = null, \AcumaticaConfig\StructType\DecimalValue $currencyPtdTotal = null, \AcumaticaConfig\StructType\DecimalValue $debitTotal = null, \AcumaticaConfig\StructType\StringValue $description = null, \AcumaticaConfig\StructType\DecimalValue $endingBalance = null, \AcumaticaConfig\StructType\StringValue $lastActivity = null, \AcumaticaConfig\StructType\IntValue $ledgerID = null, \AcumaticaConfig\StructType\DecimalValue $ptdTotal = null, \AcumaticaConfig\StructType\StringValue $subaccount = null, \AcumaticaConfig\StructType\StringValue $type = null)
    {
        $this
            ->setAccount($account)
            ->setAccountClass($accountClass)
            ->setBeginingBalance($beginingBalance)
            ->setBranch($branch)
            ->setConsolidationAccount($consolidationAccount)
            ->setCreditTotal($creditTotal)
            ->setCurrencyBeginingBalance($currencyBeginingBalance)
            ->setCurrencyCreditTotal($currencyCreditTotal)
            ->setCurrencyDebitTotal($currencyDebitTotal)
            ->setCurrencyEndingBalance($currencyEndingBalance)
            ->setCurrencyID($currencyID)
            ->setCurrencyPtdTotal($currencyPtdTotal)
            ->setDebitTotal($debitTotal)
            ->setDescription($description)
            ->setEndingBalance($endingBalance)
            ->setLastActivity($lastActivity)
            ->setLedgerID($ledgerID)
            ->setPtdTotal($ptdTotal)
            ->setSubaccount($subaccount)
            ->setType($type);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $account
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setAccount(\AcumaticaConfig\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get AccountClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccountClass()
    {
        return isset($this->AccountClass) ? $this->AccountClass : null;
    }
    /**
     * Set AccountClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $accountClass
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setAccountClass(\AcumaticaConfig\StructType\StringValue $accountClass = null)
    {
        if (is_null($accountClass) || (is_array($accountClass) && empty($accountClass))) {
            unset($this->AccountClass);
        } else {
            $this->AccountClass = $accountClass;
        }
        return $this;
    }
    /**
     * Get BeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getBeginingBalance()
    {
        return isset($this->BeginingBalance) ? $this->BeginingBalance : null;
    }
    /**
     * Set BeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $beginingBalance
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setBeginingBalance(\AcumaticaConfig\StructType\DecimalValue $beginingBalance = null)
    {
        if (is_null($beginingBalance) || (is_array($beginingBalance) && empty($beginingBalance))) {
            unset($this->BeginingBalance);
        } else {
            $this->BeginingBalance = $beginingBalance;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setBranch(\AcumaticaConfig\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get ConsolidationAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getConsolidationAccount()
    {
        return isset($this->ConsolidationAccount) ? $this->ConsolidationAccount : null;
    }
    /**
     * Set ConsolidationAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $consolidationAccount
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setConsolidationAccount(\AcumaticaConfig\StructType\StringValue $consolidationAccount = null)
    {
        if (is_null($consolidationAccount) || (is_array($consolidationAccount) && empty($consolidationAccount))) {
            unset($this->ConsolidationAccount);
        } else {
            $this->ConsolidationAccount = $consolidationAccount;
        }
        return $this;
    }
    /**
     * Get CreditTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCreditTotal()
    {
        return isset($this->CreditTotal) ? $this->CreditTotal : null;
    }
    /**
     * Set CreditTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $creditTotal
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setCreditTotal(\AcumaticaConfig\StructType\DecimalValue $creditTotal = null)
    {
        if (is_null($creditTotal) || (is_array($creditTotal) && empty($creditTotal))) {
            unset($this->CreditTotal);
        } else {
            $this->CreditTotal = $creditTotal;
        }
        return $this;
    }
    /**
     * Get CurrencyBeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrencyBeginingBalance()
    {
        return isset($this->CurrencyBeginingBalance) ? $this->CurrencyBeginingBalance : null;
    }
    /**
     * Set CurrencyBeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyBeginingBalance
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setCurrencyBeginingBalance(\AcumaticaConfig\StructType\DecimalValue $currencyBeginingBalance = null)
    {
        if (is_null($currencyBeginingBalance) || (is_array($currencyBeginingBalance) && empty($currencyBeginingBalance))) {
            unset($this->CurrencyBeginingBalance);
        } else {
            $this->CurrencyBeginingBalance = $currencyBeginingBalance;
        }
        return $this;
    }
    /**
     * Get CurrencyCreditTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrencyCreditTotal()
    {
        return isset($this->CurrencyCreditTotal) ? $this->CurrencyCreditTotal : null;
    }
    /**
     * Set CurrencyCreditTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyCreditTotal
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setCurrencyCreditTotal(\AcumaticaConfig\StructType\DecimalValue $currencyCreditTotal = null)
    {
        if (is_null($currencyCreditTotal) || (is_array($currencyCreditTotal) && empty($currencyCreditTotal))) {
            unset($this->CurrencyCreditTotal);
        } else {
            $this->CurrencyCreditTotal = $currencyCreditTotal;
        }
        return $this;
    }
    /**
     * Get CurrencyDebitTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrencyDebitTotal()
    {
        return isset($this->CurrencyDebitTotal) ? $this->CurrencyDebitTotal : null;
    }
    /**
     * Set CurrencyDebitTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyDebitTotal
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setCurrencyDebitTotal(\AcumaticaConfig\StructType\DecimalValue $currencyDebitTotal = null)
    {
        if (is_null($currencyDebitTotal) || (is_array($currencyDebitTotal) && empty($currencyDebitTotal))) {
            unset($this->CurrencyDebitTotal);
        } else {
            $this->CurrencyDebitTotal = $currencyDebitTotal;
        }
        return $this;
    }
    /**
     * Get CurrencyEndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrencyEndingBalance()
    {
        return isset($this->CurrencyEndingBalance) ? $this->CurrencyEndingBalance : null;
    }
    /**
     * Set CurrencyEndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyEndingBalance
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setCurrencyEndingBalance(\AcumaticaConfig\StructType\DecimalValue $currencyEndingBalance = null)
    {
        if (is_null($currencyEndingBalance) || (is_array($currencyEndingBalance) && empty($currencyEndingBalance))) {
            unset($this->CurrencyEndingBalance);
        } else {
            $this->CurrencyEndingBalance = $currencyEndingBalance;
        }
        return $this;
    }
    /**
     * Get CurrencyID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getCurrencyID()
    {
        return isset($this->CurrencyID) ? $this->CurrencyID : null;
    }
    /**
     * Set CurrencyID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $currencyID
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setCurrencyID(\AcumaticaConfig\StructType\StringValue $currencyID = null)
    {
        if (is_null($currencyID) || (is_array($currencyID) && empty($currencyID))) {
            unset($this->CurrencyID);
        } else {
            $this->CurrencyID = $currencyID;
        }
        return $this;
    }
    /**
     * Get CurrencyPtdTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getCurrencyPtdTotal()
    {
        return isset($this->CurrencyPtdTotal) ? $this->CurrencyPtdTotal : null;
    }
    /**
     * Set CurrencyPtdTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $currencyPtdTotal
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setCurrencyPtdTotal(\AcumaticaConfig\StructType\DecimalValue $currencyPtdTotal = null)
    {
        if (is_null($currencyPtdTotal) || (is_array($currencyPtdTotal) && empty($currencyPtdTotal))) {
            unset($this->CurrencyPtdTotal);
        } else {
            $this->CurrencyPtdTotal = $currencyPtdTotal;
        }
        return $this;
    }
    /**
     * Get DebitTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getDebitTotal()
    {
        return isset($this->DebitTotal) ? $this->DebitTotal : null;
    }
    /**
     * Set DebitTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $debitTotal
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setDebitTotal(\AcumaticaConfig\StructType\DecimalValue $debitTotal = null)
    {
        if (is_null($debitTotal) || (is_array($debitTotal) && empty($debitTotal))) {
            unset($this->DebitTotal);
        } else {
            $this->DebitTotal = $debitTotal;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $description
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setDescription(\AcumaticaConfig\StructType\StringValue $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getEndingBalance()
    {
        return isset($this->EndingBalance) ? $this->EndingBalance : null;
    }
    /**
     * Set EndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $endingBalance
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setEndingBalance(\AcumaticaConfig\StructType\DecimalValue $endingBalance = null)
    {
        if (is_null($endingBalance) || (is_array($endingBalance) && empty($endingBalance))) {
            unset($this->EndingBalance);
        } else {
            $this->EndingBalance = $endingBalance;
        }
        return $this;
    }
    /**
     * Get LastActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLastActivity()
    {
        return isset($this->LastActivity) ? $this->LastActivity : null;
    }
    /**
     * Set LastActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $lastActivity
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setLastActivity(\AcumaticaConfig\StructType\StringValue $lastActivity = null)
    {
        if (is_null($lastActivity) || (is_array($lastActivity) && empty($lastActivity))) {
            unset($this->LastActivity);
        } else {
            $this->LastActivity = $lastActivity;
        }
        return $this;
    }
    /**
     * Get LedgerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\IntValue|null
     */
    public function getLedgerID()
    {
        return isset($this->LedgerID) ? $this->LedgerID : null;
    }
    /**
     * Set LedgerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\IntValue $ledgerID
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setLedgerID(\AcumaticaConfig\StructType\IntValue $ledgerID = null)
    {
        if (is_null($ledgerID) || (is_array($ledgerID) && empty($ledgerID))) {
            unset($this->LedgerID);
        } else {
            $this->LedgerID = $ledgerID;
        }
        return $this;
    }
    /**
     * Get PtdTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getPtdTotal()
    {
        return isset($this->PtdTotal) ? $this->PtdTotal : null;
    }
    /**
     * Set PtdTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $ptdTotal
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setPtdTotal(\AcumaticaConfig\StructType\DecimalValue $ptdTotal = null)
    {
        if (is_null($ptdTotal) || (is_array($ptdTotal) && empty($ptdTotal))) {
            unset($this->PtdTotal);
        } else {
            $this->PtdTotal = $ptdTotal;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $subaccount
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setSubaccount(\AcumaticaConfig\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $type
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public function setType(\AcumaticaConfig\StructType\StringValue $type = null)
    {
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\AccountSummaryRow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
