<?php

namespace AcumaticaConfig\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDetailsInquiry StructType
 * @subpackage Structs
 */
class AccountDetailsInquiry extends Entity
{
    /**
     * The Account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Account;
    /**
     * The BeginingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $BeginingBalance;
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Branch;
    /**
     * The EndingBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $EndingBalance;
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $FromDate;
    /**
     * The FromPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $FromPeriod;
    /**
     * The IncludeReclassified
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IncludeReclassified;
    /**
     * The IncludeUnposted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IncludeUnposted;
    /**
     * The IncludeUnreleased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\BooleanValue
     */
    public $IncludeUnreleased;
    /**
     * The Ledger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Ledger;
    /**
     * The PeriodEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $PeriodEndDate;
    /**
     * The PeriodStartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $PeriodStartDate;
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Results
     */
    public $Results;
    /**
     * The Subaccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $Subaccount;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DateTimeValue
     */
    public $ToDate;
    /**
     * The ToPeriod
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\StringValue
     */
    public $ToPeriod;
    /**
     * The Turnover
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\DecimalValue
     */
    public $Turnover;
    /**
     * Constructor method for AccountDetailsInquiry
     * @uses AccountDetailsInquiry::setAccount()
     * @uses AccountDetailsInquiry::setBeginingBalance()
     * @uses AccountDetailsInquiry::setBranch()
     * @uses AccountDetailsInquiry::setEndingBalance()
     * @uses AccountDetailsInquiry::setFromDate()
     * @uses AccountDetailsInquiry::setFromPeriod()
     * @uses AccountDetailsInquiry::setIncludeReclassified()
     * @uses AccountDetailsInquiry::setIncludeUnposted()
     * @uses AccountDetailsInquiry::setIncludeUnreleased()
     * @uses AccountDetailsInquiry::setLedger()
     * @uses AccountDetailsInquiry::setPeriodEndDate()
     * @uses AccountDetailsInquiry::setPeriodStartDate()
     * @uses AccountDetailsInquiry::setResults()
     * @uses AccountDetailsInquiry::setSubaccount()
     * @uses AccountDetailsInquiry::setToDate()
     * @uses AccountDetailsInquiry::setToPeriod()
     * @uses AccountDetailsInquiry::setTurnover()
     * @param \AcumaticaConfig\StructType\StringValue $account
     * @param \AcumaticaConfig\StructType\DecimalValue $beginingBalance
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @param \AcumaticaConfig\StructType\DecimalValue $endingBalance
     * @param \AcumaticaConfig\StructType\DateTimeValue $fromDate
     * @param \AcumaticaConfig\StructType\StringValue $fromPeriod
     * @param \AcumaticaConfig\StructType\BooleanValue $includeReclassified
     * @param \AcumaticaConfig\StructType\BooleanValue $includeUnposted
     * @param \AcumaticaConfig\StructType\BooleanValue $includeUnreleased
     * @param \AcumaticaConfig\StructType\StringValue $ledger
     * @param \AcumaticaConfig\StructType\DateTimeValue $periodEndDate
     * @param \AcumaticaConfig\StructType\DateTimeValue $periodStartDate
     * @param \AcumaticaConfig\StructType\Results $results
     * @param \AcumaticaConfig\StructType\StringValue $subaccount
     * @param \AcumaticaConfig\StructType\DateTimeValue $toDate
     * @param \AcumaticaConfig\StructType\StringValue $toPeriod
     * @param \AcumaticaConfig\StructType\DecimalValue $turnover
     */
    public function __construct(\AcumaticaConfig\StructType\StringValue $account = null, \AcumaticaConfig\StructType\DecimalValue $beginingBalance = null, \AcumaticaConfig\StructType\StringValue $branch = null, \AcumaticaConfig\StructType\DecimalValue $endingBalance = null, \AcumaticaConfig\StructType\DateTimeValue $fromDate = null, \AcumaticaConfig\StructType\StringValue $fromPeriod = null, \AcumaticaConfig\StructType\BooleanValue $includeReclassified = null, \AcumaticaConfig\StructType\BooleanValue $includeUnposted = null, \AcumaticaConfig\StructType\BooleanValue $includeUnreleased = null, \AcumaticaConfig\StructType\StringValue $ledger = null, \AcumaticaConfig\StructType\DateTimeValue $periodEndDate = null, \AcumaticaConfig\StructType\DateTimeValue $periodStartDate = null, \AcumaticaConfig\StructType\Results $results = null, \AcumaticaConfig\StructType\StringValue $subaccount = null, \AcumaticaConfig\StructType\DateTimeValue $toDate = null, \AcumaticaConfig\StructType\StringValue $toPeriod = null, \AcumaticaConfig\StructType\DecimalValue $turnover = null)
    {
        $this
            ->setAccount($account)
            ->setBeginingBalance($beginingBalance)
            ->setBranch($branch)
            ->setEndingBalance($endingBalance)
            ->setFromDate($fromDate)
            ->setFromPeriod($fromPeriod)
            ->setIncludeReclassified($includeReclassified)
            ->setIncludeUnposted($includeUnposted)
            ->setIncludeUnreleased($includeUnreleased)
            ->setLedger($ledger)
            ->setPeriodEndDate($periodEndDate)
            ->setPeriodStartDate($periodStartDate)
            ->setResults($results)
            ->setSubaccount($subaccount)
            ->setToDate($toDate)
            ->setToPeriod($toPeriod)
            ->setTurnover($turnover);
    }
    /**
     * Get Account value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getAccount()
    {
        return isset($this->Account) ? $this->Account : null;
    }
    /**
     * Set Account value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $account
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setAccount(\AcumaticaConfig\StructType\StringValue $account = null)
    {
        if (is_null($account) || (is_array($account) && empty($account))) {
            unset($this->Account);
        } else {
            $this->Account = $account;
        }
        return $this;
    }
    /**
     * Get BeginingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getBeginingBalance()
    {
        return isset($this->BeginingBalance) ? $this->BeginingBalance : null;
    }
    /**
     * Set BeginingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $beginingBalance
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setBeginingBalance(\AcumaticaConfig\StructType\DecimalValue $beginingBalance = null)
    {
        if (is_null($beginingBalance) || (is_array($beginingBalance) && empty($beginingBalance))) {
            unset($this->BeginingBalance);
        } else {
            $this->BeginingBalance = $beginingBalance;
        }
        return $this;
    }
    /**
     * Get Branch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getBranch()
    {
        return isset($this->Branch) ? $this->Branch : null;
    }
    /**
     * Set Branch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $branch
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setBranch(\AcumaticaConfig\StructType\StringValue $branch = null)
    {
        if (is_null($branch) || (is_array($branch) && empty($branch))) {
            unset($this->Branch);
        } else {
            $this->Branch = $branch;
        }
        return $this;
    }
    /**
     * Get EndingBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getEndingBalance()
    {
        return isset($this->EndingBalance) ? $this->EndingBalance : null;
    }
    /**
     * Set EndingBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $endingBalance
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setEndingBalance(\AcumaticaConfig\StructType\DecimalValue $endingBalance = null)
    {
        if (is_null($endingBalance) || (is_array($endingBalance) && empty($endingBalance))) {
            unset($this->EndingBalance);
        } else {
            $this->EndingBalance = $endingBalance;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $fromDate
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setFromDate(\AcumaticaConfig\StructType\DateTimeValue $fromDate = null)
    {
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FromPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getFromPeriod()
    {
        return isset($this->FromPeriod) ? $this->FromPeriod : null;
    }
    /**
     * Set FromPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $fromPeriod
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setFromPeriod(\AcumaticaConfig\StructType\StringValue $fromPeriod = null)
    {
        if (is_null($fromPeriod) || (is_array($fromPeriod) && empty($fromPeriod))) {
            unset($this->FromPeriod);
        } else {
            $this->FromPeriod = $fromPeriod;
        }
        return $this;
    }
    /**
     * Get IncludeReclassified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIncludeReclassified()
    {
        return isset($this->IncludeReclassified) ? $this->IncludeReclassified : null;
    }
    /**
     * Set IncludeReclassified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $includeReclassified
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setIncludeReclassified(\AcumaticaConfig\StructType\BooleanValue $includeReclassified = null)
    {
        if (is_null($includeReclassified) || (is_array($includeReclassified) && empty($includeReclassified))) {
            unset($this->IncludeReclassified);
        } else {
            $this->IncludeReclassified = $includeReclassified;
        }
        return $this;
    }
    /**
     * Get IncludeUnposted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIncludeUnposted()
    {
        return isset($this->IncludeUnposted) ? $this->IncludeUnposted : null;
    }
    /**
     * Set IncludeUnposted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $includeUnposted
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setIncludeUnposted(\AcumaticaConfig\StructType\BooleanValue $includeUnposted = null)
    {
        if (is_null($includeUnposted) || (is_array($includeUnposted) && empty($includeUnposted))) {
            unset($this->IncludeUnposted);
        } else {
            $this->IncludeUnposted = $includeUnposted;
        }
        return $this;
    }
    /**
     * Get IncludeUnreleased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\BooleanValue|null
     */
    public function getIncludeUnreleased()
    {
        return isset($this->IncludeUnreleased) ? $this->IncludeUnreleased : null;
    }
    /**
     * Set IncludeUnreleased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\BooleanValue $includeUnreleased
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setIncludeUnreleased(\AcumaticaConfig\StructType\BooleanValue $includeUnreleased = null)
    {
        if (is_null($includeUnreleased) || (is_array($includeUnreleased) && empty($includeUnreleased))) {
            unset($this->IncludeUnreleased);
        } else {
            $this->IncludeUnreleased = $includeUnreleased;
        }
        return $this;
    }
    /**
     * Get Ledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getLedger()
    {
        return isset($this->Ledger) ? $this->Ledger : null;
    }
    /**
     * Set Ledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $ledger
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setLedger(\AcumaticaConfig\StructType\StringValue $ledger = null)
    {
        if (is_null($ledger) || (is_array($ledger) && empty($ledger))) {
            unset($this->Ledger);
        } else {
            $this->Ledger = $ledger;
        }
        return $this;
    }
    /**
     * Get PeriodEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getPeriodEndDate()
    {
        return isset($this->PeriodEndDate) ? $this->PeriodEndDate : null;
    }
    /**
     * Set PeriodEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $periodEndDate
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setPeriodEndDate(\AcumaticaConfig\StructType\DateTimeValue $periodEndDate = null)
    {
        if (is_null($periodEndDate) || (is_array($periodEndDate) && empty($periodEndDate))) {
            unset($this->PeriodEndDate);
        } else {
            $this->PeriodEndDate = $periodEndDate;
        }
        return $this;
    }
    /**
     * Get PeriodStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getPeriodStartDate()
    {
        return isset($this->PeriodStartDate) ? $this->PeriodStartDate : null;
    }
    /**
     * Set PeriodStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $periodStartDate
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setPeriodStartDate(\AcumaticaConfig\StructType\DateTimeValue $periodStartDate = null)
    {
        if (is_null($periodStartDate) || (is_array($periodStartDate) && empty($periodStartDate))) {
            unset($this->PeriodStartDate);
        } else {
            $this->PeriodStartDate = $periodStartDate;
        }
        return $this;
    }
    /**
     * Get Results value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Results|null
     */
    public function getResults()
    {
        return isset($this->Results) ? $this->Results : null;
    }
    /**
     * Set Results value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\Results $results
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setResults(\AcumaticaConfig\StructType\Results $results = null)
    {
        if (is_null($results) || (is_array($results) && empty($results))) {
            unset($this->Results);
        } else {
            $this->Results = $results;
        }
        return $this;
    }
    /**
     * Get Subaccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getSubaccount()
    {
        return isset($this->Subaccount) ? $this->Subaccount : null;
    }
    /**
     * Set Subaccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $subaccount
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setSubaccount(\AcumaticaConfig\StructType\StringValue $subaccount = null)
    {
        if (is_null($subaccount) || (is_array($subaccount) && empty($subaccount))) {
            unset($this->Subaccount);
        } else {
            $this->Subaccount = $subaccount;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DateTimeValue|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DateTimeValue $toDate
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setToDate(\AcumaticaConfig\StructType\DateTimeValue $toDate = null)
    {
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get ToPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\StringValue|null
     */
    public function getToPeriod()
    {
        return isset($this->ToPeriod) ? $this->ToPeriod : null;
    }
    /**
     * Set ToPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\StringValue $toPeriod
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setToPeriod(\AcumaticaConfig\StructType\StringValue $toPeriod = null)
    {
        if (is_null($toPeriod) || (is_array($toPeriod) && empty($toPeriod))) {
            unset($this->ToPeriod);
        } else {
            $this->ToPeriod = $toPeriod;
        }
        return $this;
    }
    /**
     * Get Turnover value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\DecimalValue|null
     */
    public function getTurnover()
    {
        return isset($this->Turnover) ? $this->Turnover : null;
    }
    /**
     * Set Turnover value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \AcumaticaConfig\StructType\DecimalValue $turnover
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public function setTurnover(\AcumaticaConfig\StructType\DecimalValue $turnover = null)
    {
        if (is_null($turnover) || (is_array($turnover) && empty($turnover))) {
            unset($this->Turnover);
        } else {
            $this->Turnover = $turnover;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\StructType\AccountDetailsInquiry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
