<?php

namespace AcumaticaConfig\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetBusinessDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\SetBusinessDate $parameters
     * @return \AcumaticaConfig\StructType\SetBusinessDateResponse|bool
     */
    public function SetBusinessDate(\AcumaticaConfig\StructType\SetBusinessDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->SetBusinessDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AcumaticaConfig\StructType\SetBusinessDateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
