<?php

namespace AcumaticaConfig\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\GetList $parameters
     * @return \AcumaticaConfig\StructType\GetListResponse|bool
     */
    public function GetList(\AcumaticaConfig\StructType\GetList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Get
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\Get $parameters
     * @return \AcumaticaConfig\StructType\GetResponse|bool
     */
    public function Get(\AcumaticaConfig\StructType\Get $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomFieldSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\GetCustomFieldSchema $parameters
     * @return \AcumaticaConfig\StructType\GetCustomFieldSchemaResponse|bool
     */
    public function GetCustomFieldSchema(\AcumaticaConfig\StructType\GetCustomFieldSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomFieldSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProcessStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\GetProcessStatus $parameters
     * @return \AcumaticaConfig\StructType\GetProcessStatusResponse|bool
     */
    public function GetProcessStatus(\AcumaticaConfig\StructType\GetProcessStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProcessStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFiles
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AcumaticaConfig\StructType\GetFiles $parameters
     * @return \AcumaticaConfig\StructType\GetFilesResponse|bool
     */
    public function GetFiles(\AcumaticaConfig\StructType\GetFiles $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFiles($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AcumaticaConfig\StructType\GetCustomFieldSchemaResponse|\AcumaticaConfig\StructType\GetFilesResponse|\AcumaticaConfig\StructType\GetListResponse|\AcumaticaConfig\StructType\GetProcessStatusResponse|\AcumaticaConfig\StructType\GetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
