<?php

namespace AcumaticaConfig\EnumType;

/**
 * This class stands for ProcessStatus EnumType
 * @subpackage Enumerations
 */
class ProcessStatus
{
    /**
     * Constant for value 'NotExists'
     * @return string 'NotExists'
     */
    const VALUE_NOT_EXISTS = 'NotExists';
    /**
     * Constant for value 'InProcess'
     * @return string 'InProcess'
     */
    const VALUE_IN_PROCESS = 'InProcess';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Aborted'
     * @return string 'Aborted'
     */
    const VALUE_ABORTED = 'Aborted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_EXISTS
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_ABORTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_EXISTS,
            self::VALUE_IN_PROCESS,
            self::VALUE_COMPLETED,
            self::VALUE_ABORTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
