<?php

namespace AcumaticaConfig\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFile ArrayType
 * @subpackage Arrays
 */
class ArrayOfFile extends AbstractStructArrayBase
{
    /**
     * The File
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\File[]
     */
    public $File;
    /**
     * Constructor method for ArrayOfFile
     * @uses ArrayOfFile::setFile()
     * @param \AcumaticaConfig\StructType\File[] $file
     */
    public function __construct(array $file = array())
    {
        $this
            ->setFile($file);
    }
    /**
     * Get File value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\File[]|null
     */
    public function getFile()
    {
        return isset($this->File) ? $this->File : null;
    }
    /**
     * Set File value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\File[] $file
     * @return \AcumaticaConfig\ArrayType\ArrayOfFile
     */
    public function setFile(array $file = array())
    {
        foreach ($file as $arrayOfFileFileItem) {
            // validation for constraint: itemType
            if (!$arrayOfFileFileItem instanceof \AcumaticaConfig\StructType\File) {
                throw new \InvalidArgumentException(sprintf('The File property can only contain items of \AcumaticaConfig\StructType\File, "%s" given', is_object($arrayOfFileFileItem) ? get_class($arrayOfFileFileItem) : gettype($arrayOfFileFileItem)), __LINE__);
            }
        }
        if (is_null($file) || (is_array($file) && empty($file))) {
            unset($this->File);
        } else {
            $this->File = $file;
        }
        return $this;
    }
    /**
     * Add item to File value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\File $item
     * @return \AcumaticaConfig\ArrayType\ArrayOfFile
     */
    public function addToFile(\AcumaticaConfig\StructType\File $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\File) {
            throw new \InvalidArgumentException(sprintf('The File property can only contain items of \AcumaticaConfig\StructType\File, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->File[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \AcumaticaConfig\StructType\File|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \AcumaticaConfig\StructType\File|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \AcumaticaConfig\StructType\File|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \AcumaticaConfig\StructType\File|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \AcumaticaConfig\StructType\File|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string File
     */
    public function getAttributeName()
    {
        return 'File';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\ArrayType\ArrayOfFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
