<?php

namespace AcumaticaConfig\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEntity ArrayType
 * @subpackage Arrays
 */
class ArrayOfEntity extends AbstractStructArrayBase
{
    /**
     * The Entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \AcumaticaConfig\StructType\Entity[]
     */
    public $Entity;
    /**
     * Constructor method for ArrayOfEntity
     * @uses ArrayOfEntity::setEntity()
     * @param \AcumaticaConfig\StructType\Entity[] $entity
     */
    public function __construct(array $entity = array())
    {
        $this
            ->setEntity($entity);
    }
    /**
     * Get Entity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \AcumaticaConfig\StructType\Entity[]|null
     */
    public function getEntity()
    {
        return isset($this->Entity) ? $this->Entity : null;
    }
    /**
     * Set Entity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\Entity[] $entity
     * @return \AcumaticaConfig\ArrayType\ArrayOfEntity
     */
    public function setEntity(array $entity = array())
    {
        foreach ($entity as $arrayOfEntityEntityItem) {
            // validation for constraint: itemType
            if (!$arrayOfEntityEntityItem instanceof \AcumaticaConfig\StructType\Entity) {
                throw new \InvalidArgumentException(sprintf('The Entity property can only contain items of \AcumaticaConfig\StructType\Entity, "%s" given', is_object($arrayOfEntityEntityItem) ? get_class($arrayOfEntityEntityItem) : gettype($arrayOfEntityEntityItem)), __LINE__);
            }
        }
        if (is_null($entity) || (is_array($entity) && empty($entity))) {
            unset($this->Entity);
        } else {
            $this->Entity = $entity;
        }
        return $this;
    }
    /**
     * Add item to Entity value
     * @throws \InvalidArgumentException
     * @param \AcumaticaConfig\StructType\Entity $item
     * @return \AcumaticaConfig\ArrayType\ArrayOfEntity
     */
    public function addToEntity(\AcumaticaConfig\StructType\Entity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AcumaticaConfig\StructType\Entity) {
            throw new \InvalidArgumentException(sprintf('The Entity property can only contain items of \AcumaticaConfig\StructType\Entity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Entity[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \AcumaticaConfig\StructType\Entity|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \AcumaticaConfig\StructType\Entity|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \AcumaticaConfig\StructType\Entity|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \AcumaticaConfig\StructType\Entity|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \AcumaticaConfig\StructType\Entity|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Entity
     */
    public function getAttributeName()
    {
        return 'Entity';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \AcumaticaConfig\ArrayType\ArrayOfEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
