<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \LGCLSR\ClassMap::get(),
);
/**
 * Samples for Member ServiceType
 */
$member = new \LGCLSR\ServiceType\Member($options);
/**
 * Sample call for memberBurn operation/method
 */
if ($member->memberBurn($ws_username, $ws_password, $mobilenumber, $memberPin, $transAmount, $transRef) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for memberBalance operation/method
 */
if ($member->memberBalance($ws_username, $ws_password, $mobilenumber, $memberPin) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Sample call for memberEarn operation/method
 */
if ($member->memberEarn($ws_username, $ws_password, $mobilenumber, $memberPin, $transAmount, $transRef) !== false) {
    print_r($member->getResult());
} else {
    print_r($member->getLastError());
}
/**
 * Samples for Register ServiceType
 */
$register = new \LGCLSR\ServiceType\Register($options);
/**
 * Sample call for RegisterMember operation/method
 */
if ($register->RegisterMember($ws_username, $ws_password, $mobilenumber, $memberPin, $memberName, $memberLastname, $terminalGender, $terminalBirthdate, $terminalIDType, $terminalIDNumber, $emailAddress, $cardNumber, $address1, $address2, $postalCode) !== false) {
    print_r($register->getResult());
} else {
    print_r($register->getLastError());
}
