<?php

namespace LGCLSR\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegisterMember
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $ws_username
     * @param string $ws_password
     * @param string $mobilenumber
     * @param string $memberPin
     * @param string $memberName
     * @param string $memberLastname
     * @param string $terminalGender
     * @param string $terminalBirthdate
     * @param string $terminalIDType
     * @param string $terminalIDNumber
     * @param string $emailAddress
     * @param string $cardNumber
     * @param string $address1
     * @param string $address2
     * @param string $postalCode
     * @return \LGCLSR\StructType\Obj_RegisterMember|bool
     */
    public function RegisterMember($ws_username, $ws_password, $mobilenumber, $memberPin, $memberName, $memberLastname, $terminalGender, $terminalBirthdate, $terminalIDType, $terminalIDNumber, $emailAddress, $cardNumber, $address1, $address2, $postalCode)
    {
        try {
            $this->setResult(self::getSoapClient()->RegisterMember($ws_username, $ws_password, $mobilenumber, $memberPin, $memberName, $memberLastname, $terminalGender, $terminalBirthdate, $terminalIDType, $terminalIDNumber, $emailAddress, $cardNumber, $address1, $address2, $postalCode));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGCLSR\StructType\Obj_RegisterMember
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
