<?php

namespace LGCLSR\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Member ServiceType
 * @subpackage Services
 */
class Member extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named memberBurn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $ws_username
     * @param string $ws_password
     * @param string $mobilenumber
     * @param string $memberPin
     * @param string $transAmount
     * @param string $transRef
     * @return \LGCLSR\StructType\Obj_MemberBurn|bool
     */
    public function memberBurn($ws_username, $ws_password, $mobilenumber, $memberPin, $transAmount, $transRef)
    {
        try {
            $this->setResult(self::getSoapClient()->memberBurn($ws_username, $ws_password, $mobilenumber, $memberPin, $transAmount, $transRef));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named memberBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $ws_username
     * @param string $ws_password
     * @param string $mobilenumber
     * @param string $memberPin
     * @return \LGCLSR\StructType\Obj_MemberBalance|bool
     */
    public function memberBalance($ws_username, $ws_password, $mobilenumber, $memberPin)
    {
        try {
            $this->setResult(self::getSoapClient()->memberBalance($ws_username, $ws_password, $mobilenumber, $memberPin));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named memberEarn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $ws_username
     * @param string $ws_password
     * @param string $mobilenumber
     * @param string $memberPin
     * @param string $transAmount
     * @param string $transRef
     * @return \LGCLSR\StructType\Obj_MemberEarn|bool
     */
    public function memberEarn($ws_username, $ws_password, $mobilenumber, $memberPin, $transAmount, $transRef)
    {
        try {
            $this->setResult(self::getSoapClient()->memberEarn($ws_username, $ws_password, $mobilenumber, $memberPin, $transAmount, $transRef));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \LGCLSR\StructType\Obj_MemberBalance|\LGCLSR\StructType\Obj_MemberBurn|\LGCLSR\StructType\Obj_MemberEarn
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
