<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Nodo ServiceType
 */
$nodo = new \ServiceType\Nodo($options);
$nodo->setSoapHeaderIntestazionePPT(new \StructType\IntestazionePPT());
$nodo->setSoapHeaderIntestazioneCarrelloPPT(new \StructType\IntestazioneCarrelloPPT());
/**
 * Sample call for nodoChiediStatoRPT operation/method
 */
if ($nodo->nodoChiediStatoRPT(new \StructType\NodoChiediStatoRPT()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediListaPendentiRPT operation/method
 */
if ($nodo->nodoChiediListaPendentiRPT(new \StructType\NodoChiediListaPendentiRPT()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoInviaRPT operation/method
 */
if ($nodo->nodoInviaRPT(new \StructType\NodoInviaRPT()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoInviaCarrelloRPT operation/method
 */
if ($nodo->nodoInviaCarrelloRPT(new \StructType\NodoInviaCarrelloRPT()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediCopiaRT operation/method
 */
if ($nodo->nodoChiediCopiaRT(new \StructType\NodoChiediCopiaRT()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediInformativaPSP operation/method
 */
if ($nodo->nodoChiediInformativaPSP(new \StructType\NodoChiediInformativaPSP()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediElencoQuadraturePA operation/method
 */
if ($nodo->nodoChiediElencoQuadraturePA(new \StructType\NodoChiediElencoQuadraturePA()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediQuadraturaPA operation/method
 */
if ($nodo->nodoChiediQuadraturaPA(new \StructType\NodoChiediQuadraturaPA()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediElencoFlussiRendicontazione operation/method
 */
if ($nodo->nodoChiediElencoFlussiRendicontazione(new \StructType\NodoChiediElencoFlussiRendicontazione()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediFlussoRendicontazione operation/method
 */
if ($nodo->nodoChiediFlussoRendicontazione(new \StructType\NodoChiediFlussoRendicontazione()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoInviaRichiestaStorno operation/method
 */
if ($nodo->nodoInviaRichiestaStorno(new \StructType\NodoInviaRichiestaStorno()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
/**
 * Sample call for nodoChiediSceltaWISP operation/method
 */
if ($nodo->nodoChiediSceltaWISP(new \StructType\NodoChiediSceltaWISP()) !== false) {
    print_r($nodo->getResult());
} else {
    print_r($nodo->getLastError());
}
