<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tipoListaQuadrature StructType
 * @subpackage Structs
 */
class TipoListaQuadrature extends AbstractStructBase
{
    /**
     * The totRestituiti
     * @var int
     */
    public $totRestituiti;
    /**
     * The idQuadratura
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TipoIdQuadratura[]
     */
    public $idQuadratura;
    /**
     * Constructor method for tipoListaQuadrature
     * @uses TipoListaQuadrature::setTotRestituiti()
     * @uses TipoListaQuadrature::setIdQuadratura()
     * @param int $totRestituiti
     * @param \StructType\TipoIdQuadratura[] $idQuadratura
     */
    public function __construct($totRestituiti = null, array $idQuadratura = array())
    {
        $this
            ->setTotRestituiti($totRestituiti)
            ->setIdQuadratura($idQuadratura);
    }
    /**
     * Get totRestituiti value
     * @return int|null
     */
    public function getTotRestituiti()
    {
        return $this->totRestituiti;
    }
    /**
     * Set totRestituiti value
     * @param int $totRestituiti
     * @return \StructType\TipoListaQuadrature
     */
    public function setTotRestituiti($totRestituiti = null)
    {
        // validation for constraint: int
        if (!is_null($totRestituiti) && !is_numeric($totRestituiti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totRestituiti)), __LINE__);
        }
        $this->totRestituiti = $totRestituiti;
        return $this;
    }
    /**
     * Get idQuadratura value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TipoIdQuadratura[]|null
     */
    public function getIdQuadratura()
    {
        return isset($this->idQuadratura) ? $this->idQuadratura : null;
    }
    /**
     * Set idQuadratura value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TipoIdQuadratura[] $idQuadratura
     * @return \StructType\TipoListaQuadrature
     */
    public function setIdQuadratura(array $idQuadratura = array())
    {
        foreach ($idQuadratura as $tipoListaQuadratureIdQuadraturaItem) {
            // validation for constraint: itemType
            if (!$tipoListaQuadratureIdQuadraturaItem instanceof \StructType\TipoIdQuadratura) {
                throw new \InvalidArgumentException(sprintf('The idQuadratura property can only contain items of \StructType\TipoIdQuadratura, "%s" given', is_object($tipoListaQuadratureIdQuadraturaItem) ? get_class($tipoListaQuadratureIdQuadraturaItem) : gettype($tipoListaQuadratureIdQuadraturaItem)), __LINE__);
            }
        }
        if (is_null($idQuadratura) || (is_array($idQuadratura) && empty($idQuadratura))) {
            unset($this->idQuadratura);
        } else {
            $this->idQuadratura = $idQuadratura;
        }
        return $this;
    }
    /**
     * Add item to idQuadratura value
     * @throws \InvalidArgumentException
     * @param \StructType\TipoIdQuadratura $item
     * @return \StructType\TipoListaQuadrature
     */
    public function addToIdQuadratura(\StructType\TipoIdQuadratura $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TipoIdQuadratura) {
            throw new \InvalidArgumentException(sprintf('The idQuadratura property can only contain items of \StructType\TipoIdQuadratura, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->idQuadratura[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoListaQuadrature
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
