<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tipoElencoFlussiRendicontazione StructType
 * @subpackage Structs
 */
class TipoElencoFlussiRendicontazione extends AbstractStructBase
{
    /**
     * The totRestituiti
     * @var int
     */
    public $totRestituiti;
    /**
     * The idRendicontazione
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TipoIdRendicontazione[]
     */
    public $idRendicontazione;
    /**
     * Constructor method for tipoElencoFlussiRendicontazione
     * @uses TipoElencoFlussiRendicontazione::setTotRestituiti()
     * @uses TipoElencoFlussiRendicontazione::setIdRendicontazione()
     * @param int $totRestituiti
     * @param \StructType\TipoIdRendicontazione[] $idRendicontazione
     */
    public function __construct($totRestituiti = null, array $idRendicontazione = array())
    {
        $this
            ->setTotRestituiti($totRestituiti)
            ->setIdRendicontazione($idRendicontazione);
    }
    /**
     * Get totRestituiti value
     * @return int|null
     */
    public function getTotRestituiti()
    {
        return $this->totRestituiti;
    }
    /**
     * Set totRestituiti value
     * @param int $totRestituiti
     * @return \StructType\TipoElencoFlussiRendicontazione
     */
    public function setTotRestituiti($totRestituiti = null)
    {
        // validation for constraint: int
        if (!is_null($totRestituiti) && !is_numeric($totRestituiti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totRestituiti)), __LINE__);
        }
        $this->totRestituiti = $totRestituiti;
        return $this;
    }
    /**
     * Get idRendicontazione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TipoIdRendicontazione[]|null
     */
    public function getIdRendicontazione()
    {
        return isset($this->idRendicontazione) ? $this->idRendicontazione : null;
    }
    /**
     * Set idRendicontazione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TipoIdRendicontazione[] $idRendicontazione
     * @return \StructType\TipoElencoFlussiRendicontazione
     */
    public function setIdRendicontazione(array $idRendicontazione = array())
    {
        foreach ($idRendicontazione as $tipoElencoFlussiRendicontazioneIdRendicontazioneItem) {
            // validation for constraint: itemType
            if (!$tipoElencoFlussiRendicontazioneIdRendicontazioneItem instanceof \StructType\TipoIdRendicontazione) {
                throw new \InvalidArgumentException(sprintf('The idRendicontazione property can only contain items of \StructType\TipoIdRendicontazione, "%s" given', is_object($tipoElencoFlussiRendicontazioneIdRendicontazioneItem) ? get_class($tipoElencoFlussiRendicontazioneIdRendicontazioneItem) : gettype($tipoElencoFlussiRendicontazioneIdRendicontazioneItem)), __LINE__);
            }
        }
        if (is_null($idRendicontazione) || (is_array($idRendicontazione) && empty($idRendicontazione))) {
            unset($this->idRendicontazione);
        } else {
            $this->idRendicontazione = $idRendicontazione;
        }
        return $this;
    }
    /**
     * Add item to idRendicontazione value
     * @throws \InvalidArgumentException
     * @param \StructType\TipoIdRendicontazione $item
     * @return \StructType\TipoElencoFlussiRendicontazione
     */
    public function addToIdRendicontazione(\StructType\TipoIdRendicontazione $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TipoIdRendicontazione) {
            throw new \InvalidArgumentException(sprintf('The idRendicontazione property can only contain items of \StructType\TipoIdRendicontazione, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->idRendicontazione[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoElencoFlussiRendicontazione
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
