<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nodoChiediSceltaWISP StructType
 * Meta informations extracted from the WSDL
 * - type: ppt:nodoChiediSceltaWISP
 * @subpackage Structs
 */
class NodoChiediSceltaWISP extends AbstractStructBase
{
    /**
     * The identificativoIntermediarioPA
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoIntermediarioPA;
    /**
     * The identificativoStazioneIntermediarioPA
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoStazioneIntermediarioPA;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxLength: 15
     * - minLength: 8
     * @var string
     */
    public $password;
    /**
     * The identificativoDominio
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoDominio;
    /**
     * The keyPA
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $keyPA;
    /**
     * The keyWISP
     * Meta informations extracted from the WSDL
     * - maxLength: 40
     * - minLength: 1
     * @var string
     */
    public $keyWISP;
    /**
     * Constructor method for nodoChiediSceltaWISP
     * @uses NodoChiediSceltaWISP::setIdentificativoIntermediarioPA()
     * @uses NodoChiediSceltaWISP::setIdentificativoStazioneIntermediarioPA()
     * @uses NodoChiediSceltaWISP::setPassword()
     * @uses NodoChiediSceltaWISP::setIdentificativoDominio()
     * @uses NodoChiediSceltaWISP::setKeyPA()
     * @uses NodoChiediSceltaWISP::setKeyWISP()
     * @param string $identificativoIntermediarioPA
     * @param string $identificativoStazioneIntermediarioPA
     * @param string $password
     * @param string $identificativoDominio
     * @param string $keyPA
     * @param string $keyWISP
     */
    public function __construct($identificativoIntermediarioPA = null, $identificativoStazioneIntermediarioPA = null, $password = null, $identificativoDominio = null, $keyPA = null, $keyWISP = null)
    {
        $this
            ->setIdentificativoIntermediarioPA($identificativoIntermediarioPA)
            ->setIdentificativoStazioneIntermediarioPA($identificativoStazioneIntermediarioPA)
            ->setPassword($password)
            ->setIdentificativoDominio($identificativoDominio)
            ->setKeyPA($keyPA)
            ->setKeyWISP($keyWISP);
    }
    /**
     * Get identificativoIntermediarioPA value
     * @return string|null
     */
    public function getIdentificativoIntermediarioPA()
    {
        return $this->identificativoIntermediarioPA;
    }
    /**
     * Set identificativoIntermediarioPA value
     * @param string $identificativoIntermediarioPA
     * @return \StructType\NodoChiediSceltaWISP
     */
    public function setIdentificativoIntermediarioPA($identificativoIntermediarioPA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoIntermediarioPA) && strlen($identificativoIntermediarioPA) > 35) || (is_array($identificativoIntermediarioPA) && count($identificativoIntermediarioPA) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoIntermediarioPA) ? strlen($identificativoIntermediarioPA) : count($identificativoIntermediarioPA)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoIntermediarioPA) && strlen($identificativoIntermediarioPA) < 1) || (is_array($identificativoIntermediarioPA) && count($identificativoIntermediarioPA) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoIntermediarioPA) && !is_string($identificativoIntermediarioPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoIntermediarioPA)), __LINE__);
        }
        $this->identificativoIntermediarioPA = $identificativoIntermediarioPA;
        return $this;
    }
    /**
     * Get identificativoStazioneIntermediarioPA value
     * @return string|null
     */
    public function getIdentificativoStazioneIntermediarioPA()
    {
        return $this->identificativoStazioneIntermediarioPA;
    }
    /**
     * Set identificativoStazioneIntermediarioPA value
     * @param string $identificativoStazioneIntermediarioPA
     * @return \StructType\NodoChiediSceltaWISP
     */
    public function setIdentificativoStazioneIntermediarioPA($identificativoStazioneIntermediarioPA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoStazioneIntermediarioPA) && strlen($identificativoStazioneIntermediarioPA) > 35) || (is_array($identificativoStazioneIntermediarioPA) && count($identificativoStazioneIntermediarioPA) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoStazioneIntermediarioPA) ? strlen($identificativoStazioneIntermediarioPA) : count($identificativoStazioneIntermediarioPA)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoStazioneIntermediarioPA) && strlen($identificativoStazioneIntermediarioPA) < 1) || (is_array($identificativoStazioneIntermediarioPA) && count($identificativoStazioneIntermediarioPA) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoStazioneIntermediarioPA) && !is_string($identificativoStazioneIntermediarioPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoStazioneIntermediarioPA)), __LINE__);
        }
        $this->identificativoStazioneIntermediarioPA = $identificativoStazioneIntermediarioPA;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\NodoChiediSceltaWISP
     */
    public function setPassword($password = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($password) && strlen($password) > 15) || (is_array($password) && count($password) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($password) ? strlen($password) : count($password)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($password) && strlen($password) < 8) || (is_array($password) && count($password) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get identificativoDominio value
     * @return string|null
     */
    public function getIdentificativoDominio()
    {
        return $this->identificativoDominio;
    }
    /**
     * Set identificativoDominio value
     * @param string $identificativoDominio
     * @return \StructType\NodoChiediSceltaWISP
     */
    public function setIdentificativoDominio($identificativoDominio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoDominio) && strlen($identificativoDominio) > 35) || (is_array($identificativoDominio) && count($identificativoDominio) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoDominio) ? strlen($identificativoDominio) : count($identificativoDominio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoDominio) && strlen($identificativoDominio) < 1) || (is_array($identificativoDominio) && count($identificativoDominio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoDominio) && !is_string($identificativoDominio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoDominio)), __LINE__);
        }
        $this->identificativoDominio = $identificativoDominio;
        return $this;
    }
    /**
     * Get keyPA value
     * @return string|null
     */
    public function getKeyPA()
    {
        return $this->keyPA;
    }
    /**
     * Set keyPA value
     * @param string $keyPA
     * @return \StructType\NodoChiediSceltaWISP
     */
    public function setKeyPA($keyPA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($keyPA) && strlen($keyPA) > 40) || (is_array($keyPA) && count($keyPA) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($keyPA) ? strlen($keyPA) : count($keyPA)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($keyPA) && strlen($keyPA) < 1) || (is_array($keyPA) && count($keyPA) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($keyPA) && !is_string($keyPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyPA)), __LINE__);
        }
        $this->keyPA = $keyPA;
        return $this;
    }
    /**
     * Get keyWISP value
     * @return string|null
     */
    public function getKeyWISP()
    {
        return $this->keyWISP;
    }
    /**
     * Set keyWISP value
     * @param string $keyWISP
     * @return \StructType\NodoChiediSceltaWISP
     */
    public function setKeyWISP($keyWISP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($keyWISP) && strlen($keyWISP) > 40) || (is_array($keyWISP) && count($keyWISP) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($keyWISP) ? strlen($keyWISP) : count($keyWISP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($keyWISP) && strlen($keyWISP) < 1) || (is_array($keyWISP) && count($keyWISP) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($keyWISP) && !is_string($keyWISP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyWISP)), __LINE__);
        }
        $this->keyWISP = $keyWISP;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NodoChiediSceltaWISP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
