<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for intestazioneCarrelloPPT StructType
 * @subpackage Structs
 */
class IntestazioneCarrelloPPT extends AbstractStructBase
{
    /**
     * The identificativoIntermediarioPA
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoIntermediarioPA;
    /**
     * The identificativoStazioneIntermediarioPA
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoStazioneIntermediarioPA;
    /**
     * The identificativoCarrello
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoCarrello;
    /**
     * The actor
     * Meta informations extracted from the WSDL
     * - ref: soapenv:actor
     * - use: optional
     * @var string
     */
    public $actor;
    /**
     * The mustUnderstand
     * Meta informations extracted from the WSDL
     * - ref: soapenv:mustUnderstand
     * - use: optional
     * @var string
     */
    public $mustUnderstand;
    /**
     * Constructor method for intestazioneCarrelloPPT
     * @uses IntestazioneCarrelloPPT::setIdentificativoIntermediarioPA()
     * @uses IntestazioneCarrelloPPT::setIdentificativoStazioneIntermediarioPA()
     * @uses IntestazioneCarrelloPPT::setIdentificativoCarrello()
     * @uses IntestazioneCarrelloPPT::setActor()
     * @uses IntestazioneCarrelloPPT::setMustUnderstand()
     * @param string $identificativoIntermediarioPA
     * @param string $identificativoStazioneIntermediarioPA
     * @param string $identificativoCarrello
     * @param string $actor
     * @param string $mustUnderstand
     */
    public function __construct($identificativoIntermediarioPA = null, $identificativoStazioneIntermediarioPA = null, $identificativoCarrello = null, $actor = null, $mustUnderstand = null)
    {
        $this
            ->setIdentificativoIntermediarioPA($identificativoIntermediarioPA)
            ->setIdentificativoStazioneIntermediarioPA($identificativoStazioneIntermediarioPA)
            ->setIdentificativoCarrello($identificativoCarrello)
            ->setActor($actor)
            ->setMustUnderstand($mustUnderstand);
    }
    /**
     * Get identificativoIntermediarioPA value
     * @return string|null
     */
    public function getIdentificativoIntermediarioPA()
    {
        return $this->identificativoIntermediarioPA;
    }
    /**
     * Set identificativoIntermediarioPA value
     * @param string $identificativoIntermediarioPA
     * @return \StructType\IntestazioneCarrelloPPT
     */
    public function setIdentificativoIntermediarioPA($identificativoIntermediarioPA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoIntermediarioPA) && strlen($identificativoIntermediarioPA) > 35) || (is_array($identificativoIntermediarioPA) && count($identificativoIntermediarioPA) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoIntermediarioPA) ? strlen($identificativoIntermediarioPA) : count($identificativoIntermediarioPA)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoIntermediarioPA) && strlen($identificativoIntermediarioPA) < 1) || (is_array($identificativoIntermediarioPA) && count($identificativoIntermediarioPA) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoIntermediarioPA) && !is_string($identificativoIntermediarioPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoIntermediarioPA)), __LINE__);
        }
        $this->identificativoIntermediarioPA = $identificativoIntermediarioPA;
        return $this;
    }
    /**
     * Get identificativoStazioneIntermediarioPA value
     * @return string|null
     */
    public function getIdentificativoStazioneIntermediarioPA()
    {
        return $this->identificativoStazioneIntermediarioPA;
    }
    /**
     * Set identificativoStazioneIntermediarioPA value
     * @param string $identificativoStazioneIntermediarioPA
     * @return \StructType\IntestazioneCarrelloPPT
     */
    public function setIdentificativoStazioneIntermediarioPA($identificativoStazioneIntermediarioPA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoStazioneIntermediarioPA) && strlen($identificativoStazioneIntermediarioPA) > 35) || (is_array($identificativoStazioneIntermediarioPA) && count($identificativoStazioneIntermediarioPA) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoStazioneIntermediarioPA) ? strlen($identificativoStazioneIntermediarioPA) : count($identificativoStazioneIntermediarioPA)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoStazioneIntermediarioPA) && strlen($identificativoStazioneIntermediarioPA) < 1) || (is_array($identificativoStazioneIntermediarioPA) && count($identificativoStazioneIntermediarioPA) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoStazioneIntermediarioPA) && !is_string($identificativoStazioneIntermediarioPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoStazioneIntermediarioPA)), __LINE__);
        }
        $this->identificativoStazioneIntermediarioPA = $identificativoStazioneIntermediarioPA;
        return $this;
    }
    /**
     * Get identificativoCarrello value
     * @return string|null
     */
    public function getIdentificativoCarrello()
    {
        return $this->identificativoCarrello;
    }
    /**
     * Set identificativoCarrello value
     * @param string $identificativoCarrello
     * @return \StructType\IntestazioneCarrelloPPT
     */
    public function setIdentificativoCarrello($identificativoCarrello = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoCarrello) && strlen($identificativoCarrello) > 35) || (is_array($identificativoCarrello) && count($identificativoCarrello) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoCarrello) ? strlen($identificativoCarrello) : count($identificativoCarrello)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoCarrello) && strlen($identificativoCarrello) < 1) || (is_array($identificativoCarrello) && count($identificativoCarrello) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoCarrello) && !is_string($identificativoCarrello)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoCarrello)), __LINE__);
        }
        $this->identificativoCarrello = $identificativoCarrello;
        return $this;
    }
    /**
     * Get actor value
     * @return string|null
     */
    public function getActor()
    {
        return $this->actor;
    }
    /**
     * Set actor value
     * @param string $actor
     * @return \StructType\IntestazioneCarrelloPPT
     */
    public function setActor($actor = null)
    {
        // validation for constraint: string
        if (!is_null($actor) && !is_string($actor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actor)), __LINE__);
        }
        $this->actor = $actor;
        return $this;
    }
    /**
     * Get mustUnderstand value
     * @return string|null
     */
    public function getMustUnderstand()
    {
        return $this->mustUnderstand;
    }
    /**
     * Set mustUnderstand value
     * @param string $mustUnderstand
     * @return \StructType\IntestazioneCarrelloPPT
     */
    public function setMustUnderstand($mustUnderstand = null)
    {
        // validation for constraint: string
        if (!is_null($mustUnderstand) && !is_string($mustUnderstand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mustUnderstand)), __LINE__);
        }
        $this->mustUnderstand = $mustUnderstand;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IntestazioneCarrelloPPT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
