<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for faultBean StructType
 * @subpackage Structs
 */
class FaultBean extends AbstractStructBase
{
    /**
     * The faultCode
     * @var string
     */
    public $faultCode;
    /**
     * The faultString
     * @var string
     */
    public $faultString;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The serial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $serial;
    /**
     * Constructor method for faultBean
     * @uses FaultBean::setFaultCode()
     * @uses FaultBean::setFaultString()
     * @uses FaultBean::setId()
     * @uses FaultBean::setDescription()
     * @uses FaultBean::setSerial()
     * @param string $faultCode
     * @param string $faultString
     * @param string $id
     * @param string $description
     * @param int $serial
     */
    public function __construct($faultCode = null, $faultString = null, $id = null, $description = null, $serial = null)
    {
        $this
            ->setFaultCode($faultCode)
            ->setFaultString($faultString)
            ->setId($id)
            ->setDescription($description)
            ->setSerial($serial);
    }
    /**
     * Get faultCode value
     * @return string|null
     */
    public function getFaultCode()
    {
        return $this->faultCode;
    }
    /**
     * Set faultCode value
     * @param string $faultCode
     * @return \StructType\FaultBean
     */
    public function setFaultCode($faultCode = null)
    {
        // validation for constraint: string
        if (!is_null($faultCode) && !is_string($faultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faultCode)), __LINE__);
        }
        $this->faultCode = $faultCode;
        return $this;
    }
    /**
     * Get faultString value
     * @return string|null
     */
    public function getFaultString()
    {
        return $this->faultString;
    }
    /**
     * Set faultString value
     * @param string $faultString
     * @return \StructType\FaultBean
     */
    public function setFaultString($faultString = null)
    {
        // validation for constraint: string
        if (!is_null($faultString) && !is_string($faultString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faultString)), __LINE__);
        }
        $this->faultString = $faultString;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\FaultBean
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\FaultBean
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get serial value
     * @return int|null
     */
    public function getSerial()
    {
        return $this->serial;
    }
    /**
     * Set serial value
     * @param int $serial
     * @return \StructType\FaultBean
     */
    public function setSerial($serial = null)
    {
        // validation for constraint: int
        if (!is_null($serial) && !is_numeric($serial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serial)), __LINE__);
        }
        $this->serial = $serial;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FaultBean
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
