<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Envelope StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Envelope
 * @subpackage Structs
 */
class Envelope extends AbstractStructBase
{
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - ref: tns:Body
     * @var \StructType\Body
     */
    public $Body;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Header
     * @var \StructType\Header
     */
    public $Header;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for Envelope
     * @uses Envelope::setBody()
     * @uses Envelope::setHeader()
     * @uses Envelope::setAny()
     * @param \StructType\Body $body
     * @param \StructType\Header $header
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\Body $body = null, \StructType\Header $header = null, \DOMDocument $any = null)
    {
        $this
            ->setBody($body)
            ->setHeader($header)
            ->setAny($any);
    }
    /**
     * Get Body value
     * @return \StructType\Body
     */
    public function getBody()
    {
        return $this->Body;
    }
    /**
     * Set Body value
     * @param \StructType\Body $body
     * @return \StructType\Envelope
     */
    public function setBody(\StructType\Body $body = null)
    {
        $this->Body = $body;
        return $this;
    }
    /**
     * Get Header value
     * @return \StructType\Header|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param \StructType\Header $header
     * @return \StructType\Envelope
     */
    public function setHeader(\StructType\Header $header = null)
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\Envelope::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\Envelope
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Envelope
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
