<?php

namespace EnumType;

/**
 * This class stands for stTipoVersamento EnumType
 * @subpackage Enumerations
 */
class StTipoVersamento
{
    /**
     * Constant for value 'BBT'
     * @return string 'BBT'
     */
    const VALUE_BBT = 'BBT';
    /**
     * Constant for value 'BP'
     * @return string 'BP'
     */
    const VALUE_BP = 'BP';
    /**
     * Constant for value 'AD'
     * @return string 'AD'
     */
    const VALUE_AD = 'AD';
    /**
     * Constant for value 'CP'
     * @return string 'CP'
     */
    const VALUE_CP = 'CP';
    /**
     * Constant for value 'PO'
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Constant for value 'OBEP'
     * @return string 'OBEP'
     */
    const VALUE_OBEP = 'OBEP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BBT
     * @uses self::VALUE_BP
     * @uses self::VALUE_AD
     * @uses self::VALUE_CP
     * @uses self::VALUE_PO
     * @uses self::VALUE_OBEP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BBT,
            self::VALUE_BP,
            self::VALUE_AD,
            self::VALUE_CP,
            self::VALUE_PO,
            self::VALUE_OBEP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
