<?php

namespace EnumType;

/**
 * This class stands for stEffettuazioneScelta EnumType
 * @subpackage Enumerations
 */
class StEffettuazioneScelta
{
    /**
     * Constant for value 'SI'
     * @return string 'SI'
     */
    const VALUE_SI = 'SI';
    /**
     * Constant for value 'NO'
     * @return string 'NO'
     */
    const VALUE_NO = 'NO';
    /**
     * Constant for value 'PO'
     * @return string 'PO'
     */
    const VALUE_PO = 'PO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SI
     * @uses self::VALUE_NO
     * @uses self::VALUE_PO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SI,
            self::VALUE_NO,
            self::VALUE_PO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
