<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tipoStoricoVersamento StructType
 * @subpackage Structs
 */
class TipoStoricoVersamento extends AbstractStructBase
{
    /**
     * The progressivo
     * @var int
     */
    public $progressivo;
    /**
     * The data
     * @var string
     */
    public $data;
    /**
     * The stato
     * @var string
     */
    public $stato;
    /**
     * The descrizione
     * @var string
     */
    public $descrizione;
    /**
     * Constructor method for tipoStoricoVersamento
     * @uses TipoStoricoVersamento::setProgressivo()
     * @uses TipoStoricoVersamento::setData()
     * @uses TipoStoricoVersamento::setStato()
     * @uses TipoStoricoVersamento::setDescrizione()
     * @param int $progressivo
     * @param string $data
     * @param string $stato
     * @param string $descrizione
     */
    public function __construct($progressivo = null, $data = null, $stato = null, $descrizione = null)
    {
        $this
            ->setProgressivo($progressivo)
            ->setData($data)
            ->setStato($stato)
            ->setDescrizione($descrizione);
    }
    /**
     * Get progressivo value
     * @return int|null
     */
    public function getProgressivo()
    {
        return $this->progressivo;
    }
    /**
     * Set progressivo value
     * @param int $progressivo
     * @return \StructType\TipoStoricoVersamento
     */
    public function setProgressivo($progressivo = null)
    {
        // validation for constraint: int
        if (!is_null($progressivo) && !is_numeric($progressivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($progressivo)), __LINE__);
        }
        $this->progressivo = $progressivo;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\TipoStoricoVersamento
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get stato value
     * @return string|null
     */
    public function getStato()
    {
        return $this->stato;
    }
    /**
     * Set stato value
     * @param string $stato
     * @return \StructType\TipoStoricoVersamento
     */
    public function setStato($stato = null)
    {
        // validation for constraint: string
        if (!is_null($stato) && !is_string($stato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stato)), __LINE__);
        }
        $this->stato = $stato;
        return $this;
    }
    /**
     * Get descrizione value
     * @return string|null
     */
    public function getDescrizione()
    {
        return $this->descrizione;
    }
    /**
     * Set descrizione value
     * @param string $descrizione
     * @return \StructType\TipoStoricoVersamento
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descrizione)), __LINE__);
        }
        $this->descrizione = $descrizione;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoStoricoVersamento
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
