<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tipoRPTPendente StructType
 * @subpackage Structs
 */
class TipoRPTPendente extends AbstractStructBase
{
    /**
     * The identificativoDominio
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoDominio;
    /**
     * The identificativoUnivocoVersamento
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoUnivocoVersamento;
    /**
     * The codiceContestoPagamento
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $codiceContestoPagamento;
    /**
     * The stato
     * @var string
     */
    public $stato;
    /**
     * Constructor method for tipoRPTPendente
     * @uses TipoRPTPendente::setIdentificativoDominio()
     * @uses TipoRPTPendente::setIdentificativoUnivocoVersamento()
     * @uses TipoRPTPendente::setCodiceContestoPagamento()
     * @uses TipoRPTPendente::setStato()
     * @param string $identificativoDominio
     * @param string $identificativoUnivocoVersamento
     * @param string $codiceContestoPagamento
     * @param string $stato
     */
    public function __construct($identificativoDominio = null, $identificativoUnivocoVersamento = null, $codiceContestoPagamento = null, $stato = null)
    {
        $this
            ->setIdentificativoDominio($identificativoDominio)
            ->setIdentificativoUnivocoVersamento($identificativoUnivocoVersamento)
            ->setCodiceContestoPagamento($codiceContestoPagamento)
            ->setStato($stato);
    }
    /**
     * Get identificativoDominio value
     * @return string|null
     */
    public function getIdentificativoDominio()
    {
        return $this->identificativoDominio;
    }
    /**
     * Set identificativoDominio value
     * @param string $identificativoDominio
     * @return \StructType\TipoRPTPendente
     */
    public function setIdentificativoDominio($identificativoDominio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoDominio) && strlen($identificativoDominio) > 35) || (is_array($identificativoDominio) && count($identificativoDominio) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoDominio) ? strlen($identificativoDominio) : count($identificativoDominio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoDominio) && strlen($identificativoDominio) < 1) || (is_array($identificativoDominio) && count($identificativoDominio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoDominio) && !is_string($identificativoDominio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoDominio)), __LINE__);
        }
        $this->identificativoDominio = $identificativoDominio;
        return $this;
    }
    /**
     * Get identificativoUnivocoVersamento value
     * @return string|null
     */
    public function getIdentificativoUnivocoVersamento()
    {
        return $this->identificativoUnivocoVersamento;
    }
    /**
     * Set identificativoUnivocoVersamento value
     * @param string $identificativoUnivocoVersamento
     * @return \StructType\TipoRPTPendente
     */
    public function setIdentificativoUnivocoVersamento($identificativoUnivocoVersamento = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoUnivocoVersamento) && strlen($identificativoUnivocoVersamento) > 35) || (is_array($identificativoUnivocoVersamento) && count($identificativoUnivocoVersamento) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoUnivocoVersamento) ? strlen($identificativoUnivocoVersamento) : count($identificativoUnivocoVersamento)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoUnivocoVersamento) && strlen($identificativoUnivocoVersamento) < 1) || (is_array($identificativoUnivocoVersamento) && count($identificativoUnivocoVersamento) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoUnivocoVersamento) && !is_string($identificativoUnivocoVersamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoUnivocoVersamento)), __LINE__);
        }
        $this->identificativoUnivocoVersamento = $identificativoUnivocoVersamento;
        return $this;
    }
    /**
     * Get codiceContestoPagamento value
     * @return string|null
     */
    public function getCodiceContestoPagamento()
    {
        return $this->codiceContestoPagamento;
    }
    /**
     * Set codiceContestoPagamento value
     * @param string $codiceContestoPagamento
     * @return \StructType\TipoRPTPendente
     */
    public function setCodiceContestoPagamento($codiceContestoPagamento = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codiceContestoPagamento) && strlen($codiceContestoPagamento) > 35) || (is_array($codiceContestoPagamento) && count($codiceContestoPagamento) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($codiceContestoPagamento) ? strlen($codiceContestoPagamento) : count($codiceContestoPagamento)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($codiceContestoPagamento) && strlen($codiceContestoPagamento) < 1) || (is_array($codiceContestoPagamento) && count($codiceContestoPagamento) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codiceContestoPagamento) && !is_string($codiceContestoPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codiceContestoPagamento)), __LINE__);
        }
        $this->codiceContestoPagamento = $codiceContestoPagamento;
        return $this;
    }
    /**
     * Get stato value
     * @return string|null
     */
    public function getStato()
    {
        return $this->stato;
    }
    /**
     * Set stato value
     * @param string $stato
     * @return \StructType\TipoRPTPendente
     */
    public function setStato($stato = null)
    {
        // validation for constraint: string
        if (!is_null($stato) && !is_string($stato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stato)), __LINE__);
        }
        $this->stato = $stato;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoRPTPendente
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
