<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tipoListaRPTPendenti StructType
 * @subpackage Structs
 */
class TipoListaRPTPendenti extends AbstractStructBase
{
    /**
     * The totRestituiti
     * @var int
     */
    public $totRestituiti;
    /**
     * The rptPendente
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TipoRPTPendente[]
     */
    public $rptPendente;
    /**
     * Constructor method for tipoListaRPTPendenti
     * @uses TipoListaRPTPendenti::setTotRestituiti()
     * @uses TipoListaRPTPendenti::setRptPendente()
     * @param int $totRestituiti
     * @param \StructType\TipoRPTPendente[] $rptPendente
     */
    public function __construct($totRestituiti = null, array $rptPendente = array())
    {
        $this
            ->setTotRestituiti($totRestituiti)
            ->setRptPendente($rptPendente);
    }
    /**
     * Get totRestituiti value
     * @return int|null
     */
    public function getTotRestituiti()
    {
        return $this->totRestituiti;
    }
    /**
     * Set totRestituiti value
     * @param int $totRestituiti
     * @return \StructType\TipoListaRPTPendenti
     */
    public function setTotRestituiti($totRestituiti = null)
    {
        // validation for constraint: int
        if (!is_null($totRestituiti) && !is_numeric($totRestituiti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totRestituiti)), __LINE__);
        }
        $this->totRestituiti = $totRestituiti;
        return $this;
    }
    /**
     * Get rptPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TipoRPTPendente[]|null
     */
    public function getRptPendente()
    {
        return isset($this->rptPendente) ? $this->rptPendente : null;
    }
    /**
     * Set rptPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TipoRPTPendente[] $rptPendente
     * @return \StructType\TipoListaRPTPendenti
     */
    public function setRptPendente(array $rptPendente = array())
    {
        foreach ($rptPendente as $tipoListaRPTPendentiRptPendenteItem) {
            // validation for constraint: itemType
            if (!$tipoListaRPTPendentiRptPendenteItem instanceof \StructType\TipoRPTPendente) {
                throw new \InvalidArgumentException(sprintf('The rptPendente property can only contain items of \StructType\TipoRPTPendente, "%s" given', is_object($tipoListaRPTPendentiRptPendenteItem) ? get_class($tipoListaRPTPendentiRptPendenteItem) : gettype($tipoListaRPTPendentiRptPendenteItem)), __LINE__);
            }
        }
        if (is_null($rptPendente) || (is_array($rptPendente) && empty($rptPendente))) {
            unset($this->rptPendente);
        } else {
            $this->rptPendente = $rptPendente;
        }
        return $this;
    }
    /**
     * Add item to rptPendente value
     * @throws \InvalidArgumentException
     * @param \StructType\TipoRPTPendente $item
     * @return \StructType\TipoListaRPTPendenti
     */
    public function addToRptPendente(\StructType\TipoRPTPendente $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TipoRPTPendente) {
            throw new \InvalidArgumentException(sprintf('The rptPendente property can only contain items of \StructType\TipoRPTPendente, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rptPendente[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipoListaRPTPendenti
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
