<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nodoInviaRPT StructType
 * Meta informations extracted from the WSDL
 * - type: ppt:nodoInviaRPT
 * @subpackage Structs
 */
class NodoInviaRPT extends AbstractStructBase
{
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxLength: 15
     * - minLength: 8
     * @var string
     */
    public $password;
    /**
     * The identificativoPSP
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoPSP;
    /**
     * The identificativoIntermediarioPSP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoIntermediarioPSP;
    /**
     * The identificativoCanale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoCanale;
    /**
     * The tipoFirma
     * @var string
     */
    public $tipoFirma;
    /**
     * The rpt
     * @var string
     */
    public $rpt;
    /**
     * Constructor method for nodoInviaRPT
     * @uses NodoInviaRPT::setPassword()
     * @uses NodoInviaRPT::setIdentificativoPSP()
     * @uses NodoInviaRPT::setIdentificativoIntermediarioPSP()
     * @uses NodoInviaRPT::setIdentificativoCanale()
     * @uses NodoInviaRPT::setTipoFirma()
     * @uses NodoInviaRPT::setRpt()
     * @param string $password
     * @param string $identificativoPSP
     * @param string $identificativoIntermediarioPSP
     * @param string $identificativoCanale
     * @param string $tipoFirma
     * @param string $rpt
     */
    public function __construct($password = null, $identificativoPSP = null, $identificativoIntermediarioPSP = null, $identificativoCanale = null, $tipoFirma = null, $rpt = null)
    {
        $this
            ->setPassword($password)
            ->setIdentificativoPSP($identificativoPSP)
            ->setIdentificativoIntermediarioPSP($identificativoIntermediarioPSP)
            ->setIdentificativoCanale($identificativoCanale)
            ->setTipoFirma($tipoFirma)
            ->setRpt($rpt);
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\NodoInviaRPT
     */
    public function setPassword($password = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($password) && strlen($password) > 15) || (is_array($password) && count($password) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($password) ? strlen($password) : count($password)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($password) && strlen($password) < 8) || (is_array($password) && count($password) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get identificativoPSP value
     * @return string|null
     */
    public function getIdentificativoPSP()
    {
        return $this->identificativoPSP;
    }
    /**
     * Set identificativoPSP value
     * @param string $identificativoPSP
     * @return \StructType\NodoInviaRPT
     */
    public function setIdentificativoPSP($identificativoPSP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoPSP) && strlen($identificativoPSP) > 35) || (is_array($identificativoPSP) && count($identificativoPSP) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoPSP) ? strlen($identificativoPSP) : count($identificativoPSP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoPSP) && strlen($identificativoPSP) < 1) || (is_array($identificativoPSP) && count($identificativoPSP) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoPSP) && !is_string($identificativoPSP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoPSP)), __LINE__);
        }
        $this->identificativoPSP = $identificativoPSP;
        return $this;
    }
    /**
     * Get identificativoIntermediarioPSP value
     * @return string|null
     */
    public function getIdentificativoIntermediarioPSP()
    {
        return $this->identificativoIntermediarioPSP;
    }
    /**
     * Set identificativoIntermediarioPSP value
     * @param string $identificativoIntermediarioPSP
     * @return \StructType\NodoInviaRPT
     */
    public function setIdentificativoIntermediarioPSP($identificativoIntermediarioPSP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoIntermediarioPSP) && strlen($identificativoIntermediarioPSP) > 35) || (is_array($identificativoIntermediarioPSP) && count($identificativoIntermediarioPSP) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoIntermediarioPSP) ? strlen($identificativoIntermediarioPSP) : count($identificativoIntermediarioPSP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoIntermediarioPSP) && strlen($identificativoIntermediarioPSP) < 1) || (is_array($identificativoIntermediarioPSP) && count($identificativoIntermediarioPSP) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoIntermediarioPSP) && !is_string($identificativoIntermediarioPSP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoIntermediarioPSP)), __LINE__);
        }
        $this->identificativoIntermediarioPSP = $identificativoIntermediarioPSP;
        return $this;
    }
    /**
     * Get identificativoCanale value
     * @return string|null
     */
    public function getIdentificativoCanale()
    {
        return $this->identificativoCanale;
    }
    /**
     * Set identificativoCanale value
     * @param string $identificativoCanale
     * @return \StructType\NodoInviaRPT
     */
    public function setIdentificativoCanale($identificativoCanale = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoCanale) && strlen($identificativoCanale) > 35) || (is_array($identificativoCanale) && count($identificativoCanale) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoCanale) ? strlen($identificativoCanale) : count($identificativoCanale)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoCanale) && strlen($identificativoCanale) < 1) || (is_array($identificativoCanale) && count($identificativoCanale) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoCanale) && !is_string($identificativoCanale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoCanale)), __LINE__);
        }
        $this->identificativoCanale = $identificativoCanale;
        return $this;
    }
    /**
     * Get tipoFirma value
     * @return string|null
     */
    public function getTipoFirma()
    {
        return $this->tipoFirma;
    }
    /**
     * Set tipoFirma value
     * @param string $tipoFirma
     * @return \StructType\NodoInviaRPT
     */
    public function setTipoFirma($tipoFirma = null)
    {
        // validation for constraint: string
        if (!is_null($tipoFirma) && !is_string($tipoFirma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoFirma)), __LINE__);
        }
        $this->tipoFirma = $tipoFirma;
        return $this;
    }
    /**
     * Get rpt value
     * @return string|null
     */
    public function getRpt()
    {
        return $this->rpt;
    }
    /**
     * Set rpt value
     * @param string $rpt
     * @return \StructType\NodoInviaRPT
     */
    public function setRpt($rpt = null)
    {
        // validation for constraint: string
        if (!is_null($rpt) && !is_string($rpt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rpt)), __LINE__);
        }
        $this->rpt = $rpt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NodoInviaRPT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
