<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nodoChiediSceltaWISPRisposta StructType
 * Meta informations extracted from the WSDL
 * - type: ppt:nodoChiediSceltaWISPRisposta
 * @subpackage Structs
 */
class NodoChiediSceltaWISPRisposta extends Risposta
{
    /**
     * The effettuazioneScelta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effettuazioneScelta;
    /**
     * The identificativoPSP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoPSP;
    /**
     * The identificativoIntermediarioPSP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoIntermediarioPSP;
    /**
     * The identificativoCanale
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoCanale;
    /**
     * The tipoVersamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoVersamento;
    /**
     * Constructor method for nodoChiediSceltaWISPRisposta
     * @uses NodoChiediSceltaWISPRisposta::setEffettuazioneScelta()
     * @uses NodoChiediSceltaWISPRisposta::setIdentificativoPSP()
     * @uses NodoChiediSceltaWISPRisposta::setIdentificativoIntermediarioPSP()
     * @uses NodoChiediSceltaWISPRisposta::setIdentificativoCanale()
     * @uses NodoChiediSceltaWISPRisposta::setTipoVersamento()
     * @param string $effettuazioneScelta
     * @param string $identificativoPSP
     * @param string $identificativoIntermediarioPSP
     * @param string $identificativoCanale
     * @param string $tipoVersamento
     */
    public function __construct($effettuazioneScelta = null, $identificativoPSP = null, $identificativoIntermediarioPSP = null, $identificativoCanale = null, $tipoVersamento = null)
    {
        $this
            ->setEffettuazioneScelta($effettuazioneScelta)
            ->setIdentificativoPSP($identificativoPSP)
            ->setIdentificativoIntermediarioPSP($identificativoIntermediarioPSP)
            ->setIdentificativoCanale($identificativoCanale)
            ->setTipoVersamento($tipoVersamento);
    }
    /**
     * Get effettuazioneScelta value
     * @return string|null
     */
    public function getEffettuazioneScelta()
    {
        return $this->effettuazioneScelta;
    }
    /**
     * Set effettuazioneScelta value
     * @uses \EnumType\StEffettuazioneScelta::valueIsValid()
     * @uses \EnumType\StEffettuazioneScelta::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $effettuazioneScelta
     * @return \StructType\NodoChiediSceltaWISPRisposta
     */
    public function setEffettuazioneScelta($effettuazioneScelta = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StEffettuazioneScelta::valueIsValid($effettuazioneScelta)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $effettuazioneScelta, implode(', ', \EnumType\StEffettuazioneScelta::getValidValues())), __LINE__);
        }
        $this->effettuazioneScelta = $effettuazioneScelta;
        return $this;
    }
    /**
     * Get identificativoPSP value
     * @return string|null
     */
    public function getIdentificativoPSP()
    {
        return $this->identificativoPSP;
    }
    /**
     * Set identificativoPSP value
     * @param string $identificativoPSP
     * @return \StructType\NodoChiediSceltaWISPRisposta
     */
    public function setIdentificativoPSP($identificativoPSP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoPSP) && strlen($identificativoPSP) > 35) || (is_array($identificativoPSP) && count($identificativoPSP) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoPSP) ? strlen($identificativoPSP) : count($identificativoPSP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoPSP) && strlen($identificativoPSP) < 1) || (is_array($identificativoPSP) && count($identificativoPSP) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoPSP) && !is_string($identificativoPSP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoPSP)), __LINE__);
        }
        $this->identificativoPSP = $identificativoPSP;
        return $this;
    }
    /**
     * Get identificativoIntermediarioPSP value
     * @return string|null
     */
    public function getIdentificativoIntermediarioPSP()
    {
        return $this->identificativoIntermediarioPSP;
    }
    /**
     * Set identificativoIntermediarioPSP value
     * @param string $identificativoIntermediarioPSP
     * @return \StructType\NodoChiediSceltaWISPRisposta
     */
    public function setIdentificativoIntermediarioPSP($identificativoIntermediarioPSP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoIntermediarioPSP) && strlen($identificativoIntermediarioPSP) > 35) || (is_array($identificativoIntermediarioPSP) && count($identificativoIntermediarioPSP) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoIntermediarioPSP) ? strlen($identificativoIntermediarioPSP) : count($identificativoIntermediarioPSP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoIntermediarioPSP) && strlen($identificativoIntermediarioPSP) < 1) || (is_array($identificativoIntermediarioPSP) && count($identificativoIntermediarioPSP) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoIntermediarioPSP) && !is_string($identificativoIntermediarioPSP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoIntermediarioPSP)), __LINE__);
        }
        $this->identificativoIntermediarioPSP = $identificativoIntermediarioPSP;
        return $this;
    }
    /**
     * Get identificativoCanale value
     * @return string|null
     */
    public function getIdentificativoCanale()
    {
        return $this->identificativoCanale;
    }
    /**
     * Set identificativoCanale value
     * @param string $identificativoCanale
     * @return \StructType\NodoChiediSceltaWISPRisposta
     */
    public function setIdentificativoCanale($identificativoCanale = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoCanale) && strlen($identificativoCanale) > 35) || (is_array($identificativoCanale) && count($identificativoCanale) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoCanale) ? strlen($identificativoCanale) : count($identificativoCanale)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoCanale) && strlen($identificativoCanale) < 1) || (is_array($identificativoCanale) && count($identificativoCanale) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoCanale) && !is_string($identificativoCanale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoCanale)), __LINE__);
        }
        $this->identificativoCanale = $identificativoCanale;
        return $this;
    }
    /**
     * Get tipoVersamento value
     * @return string|null
     */
    public function getTipoVersamento()
    {
        return $this->tipoVersamento;
    }
    /**
     * Set tipoVersamento value
     * @uses \EnumType\StTipoVersamento::valueIsValid()
     * @uses \EnumType\StTipoVersamento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoVersamento
     * @return \StructType\NodoChiediSceltaWISPRisposta
     */
    public function setTipoVersamento($tipoVersamento = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StTipoVersamento::valueIsValid($tipoVersamento)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoVersamento, implode(', ', \EnumType\StTipoVersamento::getValidValues())), __LINE__);
        }
        $this->tipoVersamento = $tipoVersamento;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NodoChiediSceltaWISPRisposta
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
