<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nodoChiediListaPendentiRPT StructType
 * Meta informations extracted from the WSDL
 * - type: ppt:nodoChiediListaPendentiRPT
 * @subpackage Structs
 */
class NodoChiediListaPendentiRPT extends AbstractStructBase
{
    /**
     * The identificativoIntermediarioPA
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoIntermediarioPA;
    /**
     * The identificativoStazioneIntermediarioPA
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoStazioneIntermediarioPA;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxLength: 15
     * - minLength: 8
     * @var string
     */
    public $password;
    /**
     * The identificativoDominio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - minLength: 1
     * @var string
     */
    public $identificativoDominio;
    /**
     * The rangeDa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rangeDa;
    /**
     * The rangeA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rangeA;
    /**
     * The dimensioneLista
     * @var int
     */
    public $dimensioneLista;
    /**
     * Constructor method for nodoChiediListaPendentiRPT
     * @uses NodoChiediListaPendentiRPT::setIdentificativoIntermediarioPA()
     * @uses NodoChiediListaPendentiRPT::setIdentificativoStazioneIntermediarioPA()
     * @uses NodoChiediListaPendentiRPT::setPassword()
     * @uses NodoChiediListaPendentiRPT::setIdentificativoDominio()
     * @uses NodoChiediListaPendentiRPT::setRangeDa()
     * @uses NodoChiediListaPendentiRPT::setRangeA()
     * @uses NodoChiediListaPendentiRPT::setDimensioneLista()
     * @param string $identificativoIntermediarioPA
     * @param string $identificativoStazioneIntermediarioPA
     * @param string $password
     * @param string $identificativoDominio
     * @param string $rangeDa
     * @param string $rangeA
     * @param int $dimensioneLista
     */
    public function __construct($identificativoIntermediarioPA = null, $identificativoStazioneIntermediarioPA = null, $password = null, $identificativoDominio = null, $rangeDa = null, $rangeA = null, $dimensioneLista = null)
    {
        $this
            ->setIdentificativoIntermediarioPA($identificativoIntermediarioPA)
            ->setIdentificativoStazioneIntermediarioPA($identificativoStazioneIntermediarioPA)
            ->setPassword($password)
            ->setIdentificativoDominio($identificativoDominio)
            ->setRangeDa($rangeDa)
            ->setRangeA($rangeA)
            ->setDimensioneLista($dimensioneLista);
    }
    /**
     * Get identificativoIntermediarioPA value
     * @return string|null
     */
    public function getIdentificativoIntermediarioPA()
    {
        return $this->identificativoIntermediarioPA;
    }
    /**
     * Set identificativoIntermediarioPA value
     * @param string $identificativoIntermediarioPA
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public function setIdentificativoIntermediarioPA($identificativoIntermediarioPA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoIntermediarioPA) && strlen($identificativoIntermediarioPA) > 35) || (is_array($identificativoIntermediarioPA) && count($identificativoIntermediarioPA) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoIntermediarioPA) ? strlen($identificativoIntermediarioPA) : count($identificativoIntermediarioPA)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoIntermediarioPA) && strlen($identificativoIntermediarioPA) < 1) || (is_array($identificativoIntermediarioPA) && count($identificativoIntermediarioPA) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoIntermediarioPA) && !is_string($identificativoIntermediarioPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoIntermediarioPA)), __LINE__);
        }
        $this->identificativoIntermediarioPA = $identificativoIntermediarioPA;
        return $this;
    }
    /**
     * Get identificativoStazioneIntermediarioPA value
     * @return string|null
     */
    public function getIdentificativoStazioneIntermediarioPA()
    {
        return $this->identificativoStazioneIntermediarioPA;
    }
    /**
     * Set identificativoStazioneIntermediarioPA value
     * @param string $identificativoStazioneIntermediarioPA
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public function setIdentificativoStazioneIntermediarioPA($identificativoStazioneIntermediarioPA = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoStazioneIntermediarioPA) && strlen($identificativoStazioneIntermediarioPA) > 35) || (is_array($identificativoStazioneIntermediarioPA) && count($identificativoStazioneIntermediarioPA) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoStazioneIntermediarioPA) ? strlen($identificativoStazioneIntermediarioPA) : count($identificativoStazioneIntermediarioPA)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoStazioneIntermediarioPA) && strlen($identificativoStazioneIntermediarioPA) < 1) || (is_array($identificativoStazioneIntermediarioPA) && count($identificativoStazioneIntermediarioPA) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoStazioneIntermediarioPA) && !is_string($identificativoStazioneIntermediarioPA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoStazioneIntermediarioPA)), __LINE__);
        }
        $this->identificativoStazioneIntermediarioPA = $identificativoStazioneIntermediarioPA;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public function setPassword($password = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($password) && strlen($password) > 15) || (is_array($password) && count($password) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($password) ? strlen($password) : count($password)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($password) && strlen($password) < 8) || (is_array($password) && count($password) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get identificativoDominio value
     * @return string|null
     */
    public function getIdentificativoDominio()
    {
        return $this->identificativoDominio;
    }
    /**
     * Set identificativoDominio value
     * @param string $identificativoDominio
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public function setIdentificativoDominio($identificativoDominio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($identificativoDominio) && strlen($identificativoDominio) > 35) || (is_array($identificativoDominio) && count($identificativoDominio) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($identificativoDominio) ? strlen($identificativoDominio) : count($identificativoDominio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($identificativoDominio) && strlen($identificativoDominio) < 1) || (is_array($identificativoDominio) && count($identificativoDominio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($identificativoDominio) && !is_string($identificativoDominio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($identificativoDominio)), __LINE__);
        }
        $this->identificativoDominio = $identificativoDominio;
        return $this;
    }
    /**
     * Get rangeDa value
     * @return string|null
     */
    public function getRangeDa()
    {
        return $this->rangeDa;
    }
    /**
     * Set rangeDa value
     * @param string $rangeDa
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public function setRangeDa($rangeDa = null)
    {
        // validation for constraint: string
        if (!is_null($rangeDa) && !is_string($rangeDa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rangeDa)), __LINE__);
        }
        $this->rangeDa = $rangeDa;
        return $this;
    }
    /**
     * Get rangeA value
     * @return string|null
     */
    public function getRangeA()
    {
        return $this->rangeA;
    }
    /**
     * Set rangeA value
     * @param string $rangeA
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public function setRangeA($rangeA = null)
    {
        // validation for constraint: string
        if (!is_null($rangeA) && !is_string($rangeA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rangeA)), __LINE__);
        }
        $this->rangeA = $rangeA;
        return $this;
    }
    /**
     * Get dimensioneLista value
     * @return int|null
     */
    public function getDimensioneLista()
    {
        return $this->dimensioneLista;
    }
    /**
     * Set dimensioneLista value
     * @param int $dimensioneLista
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public function setDimensioneLista($dimensioneLista = null)
    {
        // validation for constraint: int
        if (!is_null($dimensioneLista) && !is_numeric($dimensioneLista)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dimensioneLista)), __LINE__);
        }
        $this->dimensioneLista = $dimensioneLista;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NodoChiediListaPendentiRPT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
