<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for esitoChiediStatoRPT StructType
 * @subpackage Structs
 */
class EsitoChiediStatoRPT extends AbstractStructBase
{
    /**
     * The stato
     * @var string
     */
    public $stato;
    /**
     * The redirect
     * Meta informations extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var int
     */
    public $redirect;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The elementoStoricoRPT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TipoStoricoRPT[]
     */
    public $elementoStoricoRPT;
    /**
     * The elementoStoricoVersamento
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TipoStoricoVersamento[]
     */
    public $elementoStoricoVersamento;
    /**
     * Constructor method for esitoChiediStatoRPT
     * @uses EsitoChiediStatoRPT::setStato()
     * @uses EsitoChiediStatoRPT::setRedirect()
     * @uses EsitoChiediStatoRPT::setUrl()
     * @uses EsitoChiediStatoRPT::setElementoStoricoRPT()
     * @uses EsitoChiediStatoRPT::setElementoStoricoVersamento()
     * @param string $stato
     * @param int $redirect
     * @param string $url
     * @param \StructType\TipoStoricoRPT[] $elementoStoricoRPT
     * @param \StructType\TipoStoricoVersamento[] $elementoStoricoVersamento
     */
    public function __construct($stato = null, $redirect = 0, $url = null, array $elementoStoricoRPT = array(), array $elementoStoricoVersamento = array())
    {
        $this
            ->setStato($stato)
            ->setRedirect($redirect)
            ->setUrl($url)
            ->setElementoStoricoRPT($elementoStoricoRPT)
            ->setElementoStoricoVersamento($elementoStoricoVersamento);
    }
    /**
     * Get stato value
     * @return string|null
     */
    public function getStato()
    {
        return $this->stato;
    }
    /**
     * Set stato value
     * @param string $stato
     * @return \StructType\EsitoChiediStatoRPT
     */
    public function setStato($stato = null)
    {
        // validation for constraint: string
        if (!is_null($stato) && !is_string($stato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stato)), __LINE__);
        }
        $this->stato = $stato;
        return $this;
    }
    /**
     * Get redirect value
     * @return int|null
     */
    public function getRedirect()
    {
        return $this->redirect;
    }
    /**
     * Set redirect value
     * @param int $redirect
     * @return \StructType\EsitoChiediStatoRPT
     */
    public function setRedirect($redirect = 0)
    {
        // validation for constraint: int
        if (!is_null($redirect) && !is_numeric($redirect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($redirect)), __LINE__);
        }
        $this->redirect = $redirect;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\EsitoChiediStatoRPT
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get elementoStoricoRPT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TipoStoricoRPT[]|null
     */
    public function getElementoStoricoRPT()
    {
        return isset($this->elementoStoricoRPT) ? $this->elementoStoricoRPT : null;
    }
    /**
     * Set elementoStoricoRPT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TipoStoricoRPT[] $elementoStoricoRPT
     * @return \StructType\EsitoChiediStatoRPT
     */
    public function setElementoStoricoRPT(array $elementoStoricoRPT = array())
    {
        foreach ($elementoStoricoRPT as $esitoChiediStatoRPTElementoStoricoRPTItem) {
            // validation for constraint: itemType
            if (!$esitoChiediStatoRPTElementoStoricoRPTItem instanceof \StructType\TipoStoricoRPT) {
                throw new \InvalidArgumentException(sprintf('The elementoStoricoRPT property can only contain items of \StructType\TipoStoricoRPT, "%s" given', is_object($esitoChiediStatoRPTElementoStoricoRPTItem) ? get_class($esitoChiediStatoRPTElementoStoricoRPTItem) : gettype($esitoChiediStatoRPTElementoStoricoRPTItem)), __LINE__);
            }
        }
        if (is_null($elementoStoricoRPT) || (is_array($elementoStoricoRPT) && empty($elementoStoricoRPT))) {
            unset($this->elementoStoricoRPT);
        } else {
            $this->elementoStoricoRPT = $elementoStoricoRPT;
        }
        return $this;
    }
    /**
     * Add item to elementoStoricoRPT value
     * @throws \InvalidArgumentException
     * @param \StructType\TipoStoricoRPT $item
     * @return \StructType\EsitoChiediStatoRPT
     */
    public function addToElementoStoricoRPT(\StructType\TipoStoricoRPT $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TipoStoricoRPT) {
            throw new \InvalidArgumentException(sprintf('The elementoStoricoRPT property can only contain items of \StructType\TipoStoricoRPT, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->elementoStoricoRPT[] = $item;
        return $this;
    }
    /**
     * Get elementoStoricoVersamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TipoStoricoVersamento[]|null
     */
    public function getElementoStoricoVersamento()
    {
        return isset($this->elementoStoricoVersamento) ? $this->elementoStoricoVersamento : null;
    }
    /**
     * Set elementoStoricoVersamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TipoStoricoVersamento[] $elementoStoricoVersamento
     * @return \StructType\EsitoChiediStatoRPT
     */
    public function setElementoStoricoVersamento(array $elementoStoricoVersamento = array())
    {
        foreach ($elementoStoricoVersamento as $esitoChiediStatoRPTElementoStoricoVersamentoItem) {
            // validation for constraint: itemType
            if (!$esitoChiediStatoRPTElementoStoricoVersamentoItem instanceof \StructType\TipoStoricoVersamento) {
                throw new \InvalidArgumentException(sprintf('The elementoStoricoVersamento property can only contain items of \StructType\TipoStoricoVersamento, "%s" given', is_object($esitoChiediStatoRPTElementoStoricoVersamentoItem) ? get_class($esitoChiediStatoRPTElementoStoricoVersamentoItem) : gettype($esitoChiediStatoRPTElementoStoricoVersamentoItem)), __LINE__);
            }
        }
        if (is_null($elementoStoricoVersamento) || (is_array($elementoStoricoVersamento) && empty($elementoStoricoVersamento))) {
            unset($this->elementoStoricoVersamento);
        } else {
            $this->elementoStoricoVersamento = $elementoStoricoVersamento;
        }
        return $this;
    }
    /**
     * Add item to elementoStoricoVersamento value
     * @throws \InvalidArgumentException
     * @param \StructType\TipoStoricoVersamento $item
     * @return \StructType\EsitoChiediStatoRPT
     */
    public function addToElementoStoricoVersamento(\StructType\TipoStoricoVersamento $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TipoStoricoVersamento) {
            throw new \InvalidArgumentException(sprintf('The elementoStoricoVersamento property can only contain items of \StructType\TipoStoricoVersamento, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->elementoStoricoVersamento[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EsitoChiediStatoRPT
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
