<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Nodo ServiceType
 * @subpackage Services
 */
class Nodo extends AbstractSoapClientBase
{
    /**
     * Sets the IntestazionePPT SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\IntestazionePPT $intestazionePPT
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderIntestazionePPT(\StructType\IntestazionePPT $intestazionePPT, $nameSpace = 'http://ws.pagamenti.telematici.gov/ppthead', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'intestazionePPT', $intestazionePPT, $mustUnderstand, $actor);
    }
    /**
     * Sets the IntestazioneCarrelloPPT SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\IntestazioneCarrelloPPT $intestazioneCarrelloPPT
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderIntestazioneCarrelloPPT(\StructType\IntestazioneCarrelloPPT $intestazioneCarrelloPPT, $nameSpace = 'http://ws.pagamenti.telematici.gov/ppthead', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'intestazioneCarrelloPPT', $intestazioneCarrelloPPT, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named nodoChiediStatoRPT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediStatoRPT $bodyrichiesta
     * @return \StructType\NodoChiediStatoRPTRisposta|bool
     */
    public function nodoChiediStatoRPT(\StructType\NodoChiediStatoRPT $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediStatoRPT($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoChiediListaPendentiRPT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediListaPendentiRPT $bodyrichiesta
     * @return \StructType\NodoChiediListaPendentiRPTRisposta|bool
     */
    public function nodoChiediListaPendentiRPT(\StructType\NodoChiediListaPendentiRPT $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediListaPendentiRPT($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoInviaRPT
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: intestazionePPT
     * - SOAPHeaderNamespaces: http://ws.pagamenti.telematici.gov/ppthead
     * - SOAPHeaderTypes: \StructType\IntestazionePPT
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoInviaRPT $bodyrichiesta
     * @return \StructType\NodoInviaRPTRisposta|bool
     */
    public function nodoInviaRPT(\StructType\NodoInviaRPT $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoInviaRPT($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoInviaCarrelloRPT
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: intestazioneCarrelloPPT
     * - SOAPHeaderNamespaces: http://ws.pagamenti.telematici.gov/ppthead
     * - SOAPHeaderTypes: \StructType\IntestazioneCarrelloPPT
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoInviaCarrelloRPT $bodyrichiesta
     * @return \StructType\NodoInviaCarrelloRPTRisposta|bool
     */
    public function nodoInviaCarrelloRPT(\StructType\NodoInviaCarrelloRPT $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoInviaCarrelloRPT($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoChiediCopiaRT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediCopiaRT $bodyrichiesta
     * @return \StructType\NodoChiediCopiaRTRisposta|bool
     */
    public function nodoChiediCopiaRT(\StructType\NodoChiediCopiaRT $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediCopiaRT($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoChiediInformativaPSP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediInformativaPSP $bodyrichiesta
     * @return \StructType\NodoChiediInformativaPSPRisposta|bool
     */
    public function nodoChiediInformativaPSP(\StructType\NodoChiediInformativaPSP $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediInformativaPSP($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoChiediElencoQuadraturePA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediElencoQuadraturePA $bodyrichiesta
     * @return \StructType\NodoChiediElencoQuadraturePARisposta|bool
     */
    public function nodoChiediElencoQuadraturePA(\StructType\NodoChiediElencoQuadraturePA $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediElencoQuadraturePA($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoChiediQuadraturaPA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediQuadraturaPA $parameters
     * @return \StructType\NodoChiediQuadraturaPARisposta|bool
     */
    public function nodoChiediQuadraturaPA(\StructType\NodoChiediQuadraturaPA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediQuadraturaPA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * nodoChiediElencoFlussiRendicontazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediElencoFlussiRendicontazione $parameters
     * @return \StructType\NodoChiediElencoFlussiRendicontazioneRisposta|bool
     */
    public function nodoChiediElencoFlussiRendicontazione(\StructType\NodoChiediElencoFlussiRendicontazione $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediElencoFlussiRendicontazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoChiediFlussoRendicontazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediFlussoRendicontazione $parameters
     * @return \StructType\NodoChiediFlussoRendicontazioneRisposta|bool
     */
    public function nodoChiediFlussoRendicontazione(\StructType\NodoChiediFlussoRendicontazione $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediFlussoRendicontazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoInviaRichiestaStorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoInviaRichiestaStorno $parameters
     * @return \StructType\NodoInviaRichiestaStornoRisposta|bool
     */
    public function nodoInviaRichiestaStorno(\StructType\NodoInviaRichiestaStorno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoInviaRichiestaStorno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named nodoChiediSceltaWISP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NodoChiediSceltaWISP $bodyrichiesta
     * @return \StructType\NodoChiediSceltaWISPRisposta|bool
     */
    public function nodoChiediSceltaWISP(\StructType\NodoChiediSceltaWISP $bodyrichiesta)
    {
        try {
            $this->setResult(self::getSoapClient()->nodoChiediSceltaWISP($bodyrichiesta));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NodoChiediCopiaRTRisposta|\StructType\NodoChiediElencoFlussiRendicontazioneRisposta|\StructType\NodoChiediElencoQuadraturePARisposta|\StructType\NodoChiediFlussoRendicontazioneRisposta|\StructType\NodoChiediInformativaPSPRisposta|\StructType\NodoChiediListaPendentiRPTRisposta|\StructType\NodoChiediQuadraturaPARisposta|\StructType\NodoChiediSceltaWISPRisposta|\StructType\NodoChiediStatoRPTRisposta|\StructType\NodoInviaCarrelloRPTRisposta|\StructType\NodoInviaRichiestaStornoRisposta|\StructType\NodoInviaRPTRisposta
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
