<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://nathanspeekenbrink.nl/Published_web_service_Sollicitanten.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://nathanspeekenbrink.nl/Published_web_service_Sollicitanten.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Sollicitatie ServiceType
 */
$sollicitatie = new \ServiceType\Sollicitatie($options);
$sollicitatie->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for SollicitatieWebservicesVerwerken operation/method
 */
if ($sollicitatie->SollicitatieWebservicesVerwerken(new \StructType\SollicitatieWebservicesVerwerken()) !== false) {
    print_r($sollicitatie->getResult());
} else {
    print_r($sollicitatie->getLastError());
}
/**
 * Samples for Geef ServiceType
 */
$geef = new \ServiceType\Geef($options);
$geef->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for GeefWaardenTabelInstroomkanaal operation/method
 */
if ($geef->GeefWaardenTabelInstroomkanaal(new \StructType\GeefWaardenTabelInstroomkanaal()) !== false) {
    print_r($geef->getResult());
} else {
    print_r($geef->getLastError());
}
/**
 * Sample call for GeefWaardenTabelCriteria operation/method
 */
if ($geef->GeefWaardenTabelCriteria(new \StructType\GeefWaardenTabelCriteria()) !== false) {
    print_r($geef->getResult());
} else {
    print_r($geef->getLastError());
}
/**
 * Sample call for GeefWaardenTabelOpleidingsniveau operation/method
 */
if ($geef->GeefWaardenTabelOpleidingsniveau(new \StructType\GeefWaardenTabelOpleidingsniveau()) !== false) {
    print_r($geef->getResult());
} else {
    print_r($geef->getLastError());
}
/**
 * Sample call for GeefWaardenTabelWerkervaring operation/method
 */
if ($geef->GeefWaardenTabelWerkervaring(new \StructType\GeefWaardenTabelWerkervaring()) !== false) {
    print_r($geef->getResult());
} else {
    print_r($geef->getLastError());
}
/**
 * Sample call for GeefWaardenTabelKenmerk1 operation/method
 */
if ($geef->GeefWaardenTabelKenmerk1(new \StructType\GeefWaardenTabelKenmerk1()) !== false) {
    print_r($geef->getResult());
} else {
    print_r($geef->getLastError());
}
/**
 * Sample call for GeefWaardenTabelKenmerk2 operation/method
 */
if ($geef->GeefWaardenTabelKenmerk2(new \StructType\GeefWaardenTabelKenmerk2()) !== false) {
    print_r($geef->getResult());
} else {
    print_r($geef->getLastError());
}
/**
 * Samples for Jobalerts ServiceType
 */
$jobalerts = new \ServiceType\Jobalerts($options);
$jobalerts->setSoapHeaderAuthentication(new \StructType\Authentication());
/**
 * Sample call for JobalertsVerwerken operation/method
 */
if ($jobalerts->JobalertsVerwerken(new \StructType\JobalertsVerwerken()) !== false) {
    print_r($jobalerts->getResult());
} else {
    print_r($jobalerts->getLastError());
}
