<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SD_Kenmerk1 StructType
 * @subpackage Structs
 */
class SD_Kenmerk1 extends AbstractStructBase
{
    /**
     * The SD_Kenmerk1ID
     * @var int
     */
    public $SD_Kenmerk1ID;
    /**
     * The Code
     * @var int
     */
    public $Code;
    /**
     * The Omschrijving
     * Meta informations extracted from the WSDL
     * - maxLength: 200
     * @var string
     */
    public $Omschrijving;
    /**
     * The _Actief
     * @var bool
     */
    public $_Actief;
    /**
     * The SorteerVolgorde
     * @var int
     */
    public $SorteerVolgorde;
    /**
     * Constructor method for SD_Kenmerk1
     * @uses SD_Kenmerk1::setSD_Kenmerk1ID()
     * @uses SD_Kenmerk1::setCode()
     * @uses SD_Kenmerk1::setOmschrijving()
     * @uses SD_Kenmerk1::set_Actief()
     * @uses SD_Kenmerk1::setSorteerVolgorde()
     * @param int $sD_Kenmerk1ID
     * @param int $code
     * @param string $omschrijving
     * @param bool $_Actief
     * @param int $sorteerVolgorde
     */
    public function __construct($sD_Kenmerk1ID = null, $code = null, $omschrijving = null, $_Actief = null, $sorteerVolgorde = null)
    {
        $this
            ->setSD_Kenmerk1ID($sD_Kenmerk1ID)
            ->setCode($code)
            ->setOmschrijving($omschrijving)
            ->set_Actief($_Actief)
            ->setSorteerVolgorde($sorteerVolgorde);
    }
    /**
     * Get SD_Kenmerk1ID value
     * @return int|null
     */
    public function getSD_Kenmerk1ID()
    {
        return $this->SD_Kenmerk1ID;
    }
    /**
     * Set SD_Kenmerk1ID value
     * @param int $sD_Kenmerk1ID
     * @return \StructType\SD_Kenmerk1
     */
    public function setSD_Kenmerk1ID($sD_Kenmerk1ID = null)
    {
        // validation for constraint: int
        if (!is_null($sD_Kenmerk1ID) && !is_numeric($sD_Kenmerk1ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sD_Kenmerk1ID)), __LINE__);
        }
        $this->SD_Kenmerk1ID = $sD_Kenmerk1ID;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\SD_Kenmerk1
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Omschrijving value
     * @return string|null
     */
    public function getOmschrijving()
    {
        return $this->Omschrijving;
    }
    /**
     * Set Omschrijving value
     * @param string $omschrijving
     * @return \StructType\SD_Kenmerk1
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($omschrijving) && strlen($omschrijving) > 200) || (is_array($omschrijving) && count($omschrijving) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($omschrijving) ? strlen($omschrijving) : count($omschrijving)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($omschrijving)), __LINE__);
        }
        $this->Omschrijving = $omschrijving;
        return $this;
    }
    /**
     * Get _Actief value
     * @return bool|null
     */
    public function get_Actief()
    {
        return $this->_Actief;
    }
    /**
     * Set _Actief value
     * @param bool $_Actief
     * @return \StructType\SD_Kenmerk1
     */
    public function set_Actief($_Actief = null)
    {
        // validation for constraint: boolean
        if (!is_null($_Actief) && !is_bool($_Actief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($_Actief)), __LINE__);
        }
        $this->_Actief = $_Actief;
        return $this;
    }
    /**
     * Get SorteerVolgorde value
     * @return int|null
     */
    public function getSorteerVolgorde()
    {
        return $this->SorteerVolgorde;
    }
    /**
     * Set SorteerVolgorde value
     * @param int $sorteerVolgorde
     * @return \StructType\SD_Kenmerk1
     */
    public function setSorteerVolgorde($sorteerVolgorde = null)
    {
        // validation for constraint: int
        if (!is_null($sorteerVolgorde) && !is_numeric($sorteerVolgorde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sorteerVolgorde)), __LINE__);
        }
        $this->SorteerVolgorde = $sorteerVolgorde;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SD_Kenmerk1
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
