<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resultaat StructType
 * @subpackage Structs
 */
class Resultaat extends AbstractStructBase
{
    /**
     * The Gelukt
     * @var bool
     */
    public $Gelukt;
    /**
     * The Bericht
     * @var string
     */
    public $Bericht;
    /**
     * Constructor method for Resultaat
     * @uses Resultaat::setGelukt()
     * @uses Resultaat::setBericht()
     * @param bool $gelukt
     * @param string $bericht
     */
    public function __construct($gelukt = null, $bericht = null)
    {
        $this
            ->setGelukt($gelukt)
            ->setBericht($bericht);
    }
    /**
     * Get Gelukt value
     * @return bool|null
     */
    public function getGelukt()
    {
        return $this->Gelukt;
    }
    /**
     * Set Gelukt value
     * @param bool $gelukt
     * @return \StructType\Resultaat
     */
    public function setGelukt($gelukt = null)
    {
        // validation for constraint: boolean
        if (!is_null($gelukt) && !is_bool($gelukt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($gelukt)), __LINE__);
        }
        $this->Gelukt = $gelukt;
        return $this;
    }
    /**
     * Get Bericht value
     * @return string|null
     */
    public function getBericht()
    {
        return $this->Bericht;
    }
    /**
     * Set Bericht value
     * @param string $bericht
     * @return \StructType\Resultaat
     */
    public function setBericht($bericht = null)
    {
        // validation for constraint: string
        if (!is_null($bericht) && !is_string($bericht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bericht)), __LINE__);
        }
        $this->Bericht = $bericht;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Resultaat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
